/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards;

import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.TaskGenerator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskCard {
    public final CardSize size;
    private final List<GameTask> tasks;
    protected final CardMenu menu;

    public TaskCard(CardMenu menu, CardSize size) {
        this.size = size;
        this.tasks = new ArrayList<GameTask>();
        this.menu = menu;
        menu.setInfo(BingoMessage.INFO_REGULAR_NAME.asPhrase(new Component[0]), BingoMessage.INFO_REGULAR_DESC.asMultiline(new Component[0]));
    }

    public abstract boolean hasTeamWon(BingoTeam var1);

    public abstract TaskCard copy(@Nullable Component var1);

    public abstract boolean canGenerateSeparateCards();

    public void generateCard(TaskGenerator.GeneratorSettings settings) {
        this.setTasks(TaskGenerator.generateCardTasks(settings));
    }

    public void showInventory(PlayerHandle player) {
        this.menu.updateTasks(this.getTasks());
        this.menu.open(player);
    }

    public List<GameTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<GameTask> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
        this.menu.updateTasks(tasks);
    }

    public int getCompleteCount(@NotNull BingoTeam team) {
        int count = 0;
        for (GameTask task : this.getTasks()) {
            if (!task.isCompletedByTeam(team)) continue;
            ++count;
        }
        return count;
    }

    public int getCompleteCount(@NotNull BingoParticipant participant) {
        return (int)this.getTasks().stream().filter(t -> t.getCompletedByPlayer().isPresent() && t.getCompletedByPlayer().get().getId().equals(participant.getId())).count();
    }

    public void onTaskCompleted(BingoParticipant player, GameTask task, long timeSeconds) {
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.size.size);
        stream.writeInt(this.getTasks().size());
        for (GameTask task : this.getTasks()) {
            task.write(stream);
        }
    }
}

