/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards.hotswap;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.cards.hotswap.HotswapTaskHolder;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ExtraMath;
import io.github.steaf23.bingoreloaded.lib.util.TextColorGradient;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ExpiringHotswapTask
implements HotswapTaskHolder {
    public GameTask task;
    public int expirationTimeSeconds;
    public int recoveryTime;
    public int currentTime;
    public boolean recovering;
    private final boolean showExpirationAsDurability;
    private static final TextColorGradient EXPIRATION_GRADIENT = new TextColorGradient().addColor(TextColor.fromHexString("#ffd200"), 0.0f).addColor(TextColor.fromHexString("#e85e21"), 0.5f).addColor(TextColor.fromHexString("#750e0e"), 0.8f).addColor(NamedTextColor.DARK_GRAY, 1.0f);

    public ExpiringHotswapTask(GameTask task, int expirationTimeMinutes, int recoverTime, boolean showExpirationAsDurability) {
        this.task = task;
        this.expirationTimeSeconds = expirationTimeMinutes;
        this.recoveryTime = recoverTime;
        this.currentTime = expirationTimeMinutes;
        this.recovering = false;
        this.showExpirationAsDurability = showExpirationAsDurability;
    }

    @Override
    public ItemTemplate convertToItem(CardDisplayInfo displayInfo) {
        ItemTemplate item = this.task.toItem(displayInfo);
        if (this.isRecovering()) {
            item.addDescription("time", 1, BingoMessage.HOTSWAP_RECOVER.asPhrase(GameTimer.getTimeAsComponent(this.currentTime)).color(TextColor.fromHexString("#5cb1ff")));
        } else {
            item.addDescription("time", 1, BingoMessage.HOTSWAP_EXPIRE.asPhrase(GameTimer.getTimeAsComponent(this.currentTime)).color(this.getColorForExpirationTime()));
            if (this.showExpirationAsDurability) {
                item.setMaxDamage(this.expirationTimeSeconds);
                item.setDamage(this.currentTime);
            }
        }
        return item;
    }

    @Override
    public void startRecovering() {
        this.recovering = true;
        this.currentTime = this.recoveryTime;
    }

    @Override
    public void updateTaskTime() {
        --this.currentTime;
    }

    @Override
    public int getFullTime() {
        return this.recovering ? this.recoveryTime : this.expirationTimeSeconds;
    }

    @Override
    public int getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public GameTask getTask() {
        return this.task;
    }

    @Override
    public boolean isRecovering() {
        return this.recovering;
    }

    private TextColor getColorForExpirationTime() {
        return EXPIRATION_GRADIENT.sample(ExtraMath.map(this.currentTime, 0.0f, this.expirationTimeSeconds, 1.0f, 0.0f));
    }
}

