/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.cards.hotswap;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.cards.hotswap.HotswapTaskHolder;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import net.kyori.adventure.text.format.TextColor;

public class SimpleHotswapTask
implements HotswapTaskHolder {
    int fullTime;
    int currentTime;
    private final GameTask task;
    boolean recovering = false;

    public SimpleHotswapTask(GameTask task, int recoveryTime) {
        this.task = task;
        this.currentTime = recoveryTime;
        this.fullTime = recoveryTime;
    }

    @Override
    public GameTask getTask() {
        return this.task;
    }

    @Override
    public boolean isRecovering() {
        return this.recovering;
    }

    @Override
    public void startRecovering() {
        this.recovering = true;
    }

    @Override
    public void updateTaskTime() {
        if (this.recovering) {
            --this.currentTime;
        }
    }

    @Override
    public int getFullTime() {
        return this.recovering ? this.fullTime : -1;
    }

    @Override
    public int getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public ItemTemplate convertToItem(CardDisplayInfo displayInfo) {
        ItemTemplate item = this.task.toItem(displayInfo);
        if (this.isRecovering()) {
            item.addDescription("time", 1, BingoMessage.HOTSWAP_RECOVER.asPhrase(GameTimer.getTimeAsComponent(this.currentTime)).color(TextColor.fromHexString("#5cb1ff")));
        }
        return item;
    }
}

