/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.TaskListData;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BingoCardData {
    private static final ItemType DEFAULT_ITEM = ItemType.of("minecraft:dirt");
    public static final Set<String> DEFAULT_CARD_NAMES = Set.of("default_card", "default_card_hardcore");
    private final TaskListData listsData = new TaskListData();
    public static final byte MAX_ITEMS = 36;
    public static final byte MIN_ITEMS = 1;
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/cards");

    public boolean removeCard(String cardName) {
        if (!this.data.contains(cardName)) {
            return false;
        }
        if (DEFAULT_CARD_NAMES.contains(cardName)) {
            ConsoleMessenger.error("Cannot remove default card!");
            return false;
        }
        this.data.erase(cardName);
        this.data.saveChanges();
        return true;
    }

    public boolean duplicateCard(String cardName) {
        if (!this.data.contains(cardName)) {
            return false;
        }
        DataStorage card = this.data.getStorage(cardName);
        this.data.setStorage(cardName + "_copy", card);
        this.data.saveChanges();
        return true;
    }

    public boolean renameCard(String cardName, String newName) {
        if (DEFAULT_CARD_NAMES.contains(cardName) || DEFAULT_CARD_NAMES.contains(newName)) {
            return false;
        }
        if (!this.data.contains(cardName)) {
            return false;
        }
        if (this.data.contains(newName)) {
            return false;
        }
        DataStorage card = this.data.getStorage(cardName);
        this.data.setStorage(newName, card);
        this.data.erase(cardName);
        this.data.saveChanges();
        return true;
    }

    public Set<String> getCardNames() {
        return this.data.getKeys();
    }

    public byte getListMax(String cardName, String listName) {
        return this.data.getByte(cardName + "." + listName + ".max", (byte)36);
    }

    public byte getListMin(String cardName, String listName) {
        return this.data.getByte(cardName + "." + listName + ".min", (byte)1);
    }

    public void setList(String cardName, String listName, int max, int min) {
        this.data.setByte(cardName + "." + listName + ".max", (byte)Math.min(max, 36));
        this.data.setByte(cardName + "." + listName + ".min", (byte)Math.max(min, 1));
        this.data.saveChanges();
    }

    public void removeList(String cardName, String listName) {
        this.data.erase(cardName + "." + listName);
    }

    public ItemTask getRandomItemTask(String cardName) {
        return this.getRandomItemTask(cardName, new Random());
    }

    public ItemTask getRandomItemTask(String cardName, @NotNull Random generator) {
        ArrayList tasks = new ArrayList();
        this.getListNames(cardName).forEach(l -> tasks.addAll(this.listsData.getTasks((String)l, false, false)));
        List<TaskData> allItemTasks = tasks.stream().filter(task -> task instanceof ItemTask).toList();
        if (!allItemTasks.isEmpty()) {
            return (ItemTask)allItemTasks.get(Math.abs(generator.nextInt(allItemTasks.size())));
        }
        return new ItemTask(DEFAULT_ITEM, 1);
    }

    public TaskData getRandomTask(String cardName, @NotNull Random generator, boolean withStatistics, boolean withAdvancements) {
        List<TaskData> allTasks = this.getAllTasks(cardName, withStatistics, withAdvancements);
        if (!allTasks.isEmpty()) {
            return allTasks.get(Math.abs(generator.nextInt(allTasks.size())));
        }
        return new ItemTask(DEFAULT_ITEM, 1);
    }

    public List<TaskData> getAllTasks(String cardName, boolean withStatistics, boolean withAdvancements) {
        ArrayList<TaskData> tasks = new ArrayList<TaskData>();
        this.getListNames(cardName).forEach(l -> tasks.addAll(this.listsData.getTasks((String)l, withStatistics, withAdvancements)));
        return tasks;
    }

    public Set<String> getListNames(String cardName) {
        if (!this.data.contains(cardName)) {
            return new HashSet<String>();
        }
        return this.data.getStorage(cardName).getKeys();
    }

    public List<String> getListsSortedByMin(String cardName) {
        ArrayList<String> result = new ArrayList<String>(this.data.getStorage(cardName).getKeys());
        result.sort((a, b) -> Integer.compare(this.getListMin(cardName, (String)a), this.getListMin(cardName, (String)b)));
        return result;
    }

    public List<String> getListsSortedByMax(String cardName) {
        ArrayList<String> result = new ArrayList<String>(this.data.getStorage(cardName).getKeys());
        result.sort((a, b) -> Integer.compare(this.getListMax(cardName, (String)a), this.getListMax(cardName, (String)b)));
        return result;
    }

    public TaskListData lists() {
        return this.listsData;
    }
}

