/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoLobby;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import org.jetbrains.annotations.Nullable;

public class BingoLobbyData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/lobby");

    public boolean isEnabled() {
        return this.data.getBoolean("enabled", false);
    }

    public void create(WorldPosition location) {
        this.data.setSerializable("lobby", BingoLobby.class, new BingoLobby(location));
        this.data.setBoolean("enabled", true);
        this.data.saveChanges();
    }

    public void remove() {
        if (!this.isEnabled()) {
            return;
        }
        this.data.setBoolean("enabled", false);
        this.data.erase("lobby");
        this.data.saveChanges();
    }

    @Nullable
    public BingoLobby getCreatedLobby() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.data.getSerializable("lobby", BingoLobby.class);
    }
}

