/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BingoSettingsData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/presets");

    @Nullable
    public BingoSettings getSettings(String name) {
        if (name.equals("default")) {
            ConsoleMessenger.error("Cannot load settings named 'default'.");
            return null;
        }
        if (this.data.contains("presets." + name)) {
            return this.data.getSerializable("presets." + name, BingoSettings.class);
        }
        if (!this.getDefaultSettingsName().isEmpty()) {
            return this.data.getSerializable("presets." + this.getDefaultSettingsName(), BingoSettings.class);
        }
        return null;
    }

    public void saveSettings(String name, BingoSettings settings) {
        if (name.isBlank()) {
            return;
        }
        if (name.equals("default")) {
            ConsoleMessenger.error("Cannot use name 'default'.");
            return;
        }
        if (this.data.contains("presets." + name)) {
            ConsoleMessenger.log("Overwritten saved preset '" + name + "' with current settings");
            this.data.erase("presets." + name);
        } else {
            ConsoleMessenger.log("Saved preset '" + name + "'");
        }
        this.data.setSerializable("presets." + name, BingoSettings.class, settings);
        this.data.saveChanges();
    }

    public void removeSettings(String name) {
        if (name.equals("default_settings")) {
            ConsoleMessenger.error("Cannot remove default settings!");
            return;
        }
        if (name.equals(this.getDefaultSettingsName())) {
            this.setDefaultSettings("default_settings");
        }
        ConsoleMessenger.log("Removed preset '" + name + "'");
        this.data.erase("presets." + name);
        this.data.saveChanges();
    }

    public String getDefaultSettingsName() {
        return this.data.getString("default", "");
    }

    @Nullable
    public BingoSettings getDefaultSettings() {
        if (!this.data.contains("default")) {
            return null;
        }
        String defaultSettingsName = this.getDefaultSettingsName();
        return this.getSettings(defaultSettingsName);
    }

    public void setDefaultSettings(String name) {
        this.data.setString("default", name);
        this.data.saveChanges();
    }

    public Set<String> getPresetNames() {
        return new HashSet<String>(this.data.getStorage("presets").getKeys());
    }
}

