/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoStatType;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerInfo;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import java.util.Arrays;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;

public class BingoStatData {
    private final ServerSoftware server;
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/player_stats");

    public BingoStatData(ServerSoftware server) {
        this.server = server;
    }

    public int getPlayerStat(UUID playerId, BingoStatType statType) {
        if (statType == BingoStatType.PLAYED) {
            return this.getPlayerStat(playerId, BingoStatType.WINS) + this.getPlayerStat(playerId, BingoStatType.LOSSES);
        }
        if (statType.idx < 0) {
            return 0;
        }
        String statsString = this.getPlayerData(playerId);
        String[] stats = statsString.split(";");
        return Integer.parseInt(stats[statType.idx]);
    }

    public void incrementPlayerStat(PlayerHandle player, BingoStatType statType) {
        this.incrementPlayerStat(player.uniqueId(), statType, 1);
    }

    public void incrementPlayerStat(UUID playerId, BingoStatType statType, int by) {
        this.setPlayerStat(playerId, statType, this.getPlayerStat(playerId, statType) + by);
    }

    public void setPlayerStat(UUID playerId, BingoStatType statType, int value) {
        String newStat;
        if (statType.idx < 0) {
            return;
        }
        String statsString = this.getPlayerData(playerId);
        CharSequence[] stats = statsString.split(";");
        stats[statType.idx] = newStat = Integer.toString(value);
        this.setPlayerData(playerId, String.join((CharSequence)";", stats));
    }

    public Component getPlayerStatsFormatted(UUID playerId) {
        String stats = this.getPlayerData(playerId);
        String[] statList = stats.split(";");
        String playerName = this.server.getPlayerInfo(playerId).playerName();
        if (playerName == null) {
            return Component.text("Statistics for invalid id " + String.valueOf(playerId) + " unavailable.");
        }
        Component[] text = BingoMessage.configStringAsMultiline("{0}'s statistics: Wins: {1}, Losses: {2}, Games finished: {3}, Tasks completed: {4}, Tasks Completed Record: {5}, Wand uses: {6}", NamedTextColor.GREEN, Component.text(playerName, (TextColor)NamedTextColor.YELLOW, TextDecoration.BOLD), Component.text(statList[0], (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD), Component.text(statList[1], (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD), Component.text(Integer.parseInt(statList[0]) + Integer.parseInt(statList[1]), (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD), Component.text(statList[2], (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD), Component.text(statList[3], (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD), Component.text(statList[4], (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD));
        return Arrays.stream(text).reduce(Component::append).get();
    }

    public Component getPlayerStatsFormatted(String playerName) {
        UUID playerId = this.getPlayerUUID(playerName);
        return this.getPlayerStatsFormatted(playerId);
    }

    private String getPlayerData(UUID playerId) {
        return this.data.getString(playerId.toString(), "0;0;0;0;0");
    }

    @NotNull
    private UUID getPlayerUUID(String playerName) {
        PlayerInfo player = this.server.getPlayerInfo(playerName);
        return player.uniqueId();
    }

    private void setPlayerData(UUID playerId, String statData) {
        this.data.setString(playerId.toString(), statData);
        this.data.saveChanges();
    }
}

