/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.settings.CustomKit;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class CustomKitData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/kits");

    public boolean assignCustomKit(Component kitName, PlayerKit slot, PlayerHandle player) {
        if (this.data.contains(slot.configName)) {
            return false;
        }
        this.data.setSerializable(slot.configName, CustomKit.class, CustomKit.fromPlayerInventory(player, kitName, slot));
        this.data.saveChanges();
        return true;
    }

    public boolean removeCustomKit(PlayerKit slot) {
        if (!this.data.contains(slot.configName)) {
            return false;
        }
        this.data.erase(slot.configName);
        this.data.saveChanges();
        return true;
    }

    @Nullable
    public CustomKit getCustomKit(PlayerKit slot) {
        return this.data.getSerializable(slot.configName, CustomKit.class);
    }
}

