/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.helper.SerializablePlayer;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSerializationData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/players");

    public void savePlayer(@NotNull SerializablePlayer player, boolean overwriteExisting) {
        if (this.data.contains(player.playerId.toString()) && !overwriteExisting) {
            return;
        }
        this.data.setSerializable(player.playerId.toString(), SerializablePlayer.class, player);
        this.data.saveChanges();
    }

    @Nullable
    public SerializablePlayer loadPlayer(@NotNull PlayerHandle player) {
        if (!this.data.contains(player.uniqueId().toString())) {
            return null;
        }
        SerializablePlayer playerData = this.data.getSerializable(player.uniqueId().toString(), SerializablePlayer.class);
        if (playerData == null) {
            return null;
        }
        this.data.erase(player.uniqueId().toString());
        this.data.saveChanges();
        playerData.apply(player);
        return playerData;
    }

    public void removePlayer(UUID playerId) {
        this.data.erase(playerId.toString());
        this.data.saveChanges();
    }

    public Set<UUID> getSavedPlayers() {
        return this.data.getKeys().stream().map(stringId -> UUID.fromString(stringId)).collect(Collectors.toSet());
    }
}

