/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.tasks.data.AdvancementTask;
import io.github.steaf23.bingoreloaded.tasks.data.StatisticTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TaskListData {
    public static final Set<String> DEFAULT_LIST_NAMES = Set.of("default_items", "default_advancements", "default_statistics", "default_items_hardcore", "default_advancements_hardcore", "default_statistics_hardcore");
    private final DataAccessor defaultData = BingoReloaded.getDataAccessor("data/default_lists");
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/" + BingoReloaded.getDefaultTasksVersion());

    public Set<TaskData> getTasks(String listName, boolean withStatistics, boolean withAdvancements) {
        List<TaskData> tasks;
        if (this.defaultData.contains(listName + ".tasks")) {
            tasks = this.defaultData.getSerializableList(listName + ".tasks", TaskData.class);
        } else if (this.data.contains(listName + ".tasks")) {
            tasks = this.data.getSerializableList(listName + ".tasks", TaskData.class);
        } else {
            return new HashSet<TaskData>();
        }
        return tasks.stream().filter(i -> !(i == null || i instanceof StatisticTask && !withStatistics || i instanceof AdvancementTask && !withAdvancements)).collect(Collectors.toSet());
    }

    public int getTaskCount(String listName) {
        if (DEFAULT_LIST_NAMES.contains(listName)) {
            return this.defaultData.getInt(listName + ".size", 0);
        }
        return this.data.getInt(listName + ".size", 0);
    }

    public void saveTasksFromGroup(String listName, List<TaskData> group, List<TaskData> tasksToSave) {
        Set<TaskData> savedTasks = this.getTasks(listName, true, true);
        Set tasksToRemove = group.stream().filter(t -> tasksToSave.stream().noneMatch(i -> i.equals(t))).collect(Collectors.toSet());
        for (TaskData t2 : tasksToRemove) {
            savedTasks.remove(t2);
        }
        for (TaskData task : tasksToSave) {
            if (savedTasks.add(task)) continue;
            savedTasks.remove(task);
            savedTasks.add(task);
        }
        this.data.setSerializableList(listName + ".tasks", TaskData.class, new ArrayList<TaskData>(savedTasks));
        this.data.setInt(listName + ".size", savedTasks.size());
        this.data.saveChanges();
    }

    public boolean removeList(String listName) {
        if (!this.data.contains(listName)) {
            return false;
        }
        if (DEFAULT_LIST_NAMES.contains(listName)) {
            ConsoleMessenger.error("Cannot remove default lists!");
            return false;
        }
        this.data.erase(listName);
        this.data.saveChanges();
        return true;
    }

    public boolean duplicateList(String listName) {
        if (!this.data.contains(listName) && !this.defaultData.contains(listName)) {
            return false;
        }
        DataStorage list = DEFAULT_LIST_NAMES.contains(listName) ? this.defaultData.getStorage(listName) : this.data.getStorage(listName);
        String newName = listName + "_copy";
        if (this.data.contains(newName)) {
            return false;
        }
        this.data.setStorage(newName, list);
        this.data.saveChanges();
        return true;
    }

    public boolean renameList(String oldName, String newName) {
        if (DEFAULT_LIST_NAMES.contains(oldName) || DEFAULT_LIST_NAMES.contains(newName)) {
            return false;
        }
        if (!this.data.contains(oldName)) {
            return false;
        }
        if (this.data.contains(newName)) {
            return false;
        }
        DataStorage list = this.data.getStorage(oldName);
        this.data.setStorage(newName, list);
        this.data.erase(oldName);
        this.data.saveChanges();
        return true;
    }

    public Set<String> getListNames() {
        HashSet<String> names = new HashSet<String>(this.defaultData.getKeys());
        names.addAll(this.data.getKeys());
        return names;
    }
}

