/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.util.BlockColor;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.lib.util.StringAdditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public class TeamData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/teams");

    public Map<String, TeamTemplate> getTeams() {
        HashMap<String, TeamTemplate> teams = new HashMap<String, TeamTemplate>();
        for (String key : this.data.getKeys()) {
            teams.put(key, this.data.getSerializable(key, TeamTemplate.class));
        }
        return teams;
    }

    public void addTeam(@NotNull String key, String name, TextColor color) {
        if (key.isEmpty()) {
            key = this.getNewTeamId();
        }
        this.data.setSerializable(key, TeamTemplate.class, new TeamTemplate(name, color));
        this.data.saveChanges();
    }

    public void addTeam(@NotNull String key, TeamTemplate template) {
        this.addTeam(key, template.stringName(), template.color());
    }

    public TeamTemplate getTeam(String key, TeamTemplate def) {
        return this.data.getSerializable(key, TeamTemplate.class, def);
    }

    public void removeTeam(String key) {
        this.data.erase(key);
        this.data.saveChanges();
    }

    public void reset() {
        for (String team : this.getTeams().keySet()) {
            this.data.erase(team);
        }
        this.data.saveChanges();
        for (BlockColor col : BlockColor.values()) {
            this.addTeam(col.name, StringAdditions.capitalize(col.name), col.textColor);
        }
    }

    public String getNewTeamId() {
        int id = 0;
        List keys = this.data.getKeys().stream().sorted().toList();
        while (keys.contains(String.valueOf(id))) {
            ++id;
        }
        return String.valueOf(id);
    }

    public record TeamTemplate(String stringName, TextColor color) {
        public Component nameComponent() {
            return ComponentUtils.MINI_BUILDER.deserialize(this.stringName);
        }
    }
}

