/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import org.jetbrains.annotations.Nullable;

public class TexturedMenuData {
    private final DataAccessor data = BingoReloaded.getDataAccessor("data/textures");

    @Nullable
    public Texture getTexture(String name) {
        if (!this.data.contains(name)) {
            ConsoleMessenger.bug("Invalid texture " + name, (Object)this);
            return null;
        }
        DataStorage n = this.data.getStorage(name);
        if (n == null) {
            return null;
        }
        String character = n.getString("char", " ");
        int textureEnd = n.getInt("texture_end", 0);
        int menuOffset = n.getInt("menu_offset", 0);
        return new Texture(character, textureEnd, menuOffset);
    }

    public record Texture(String character, int textureEnd, int menuOffset) {
    }
}

