/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.config;

import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.data.config.ConfigurationOption;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoConfigurationData {
    private final DataAccessor config;
    Map<ConfigurationOption<?>, Object> options;

    public BingoConfigurationData(DataAccessor config) {
        this.config = config;
        this.options = new HashMap();
        this.setOptionValueForce(BingoOptions.CONFIGURATION, name -> BingoOptions.PluginConfiguration.valueOf(config.getString((String)name, "SINGULAR")));
        this.setOptionValueForce(BingoOptions.DEFAULT_WORLD_NAME, name -> config.getString((String)name, "world"));
        this.setOptionValueForce(BingoOptions.LANGUAGE, name -> config.getString((String)name, "en_us.yml"));
        this.setOptionValueForce(BingoOptions.SAVE_PLAYER_STATISTICS, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.SEND_COMMAND_AFTER_GAME_ENDS, name -> config.getString((String)name, ""));
        this.setOptionValueForce(BingoOptions.SEND_COMMAND_BEFORE_GAME_STARTS, name -> config.getString((String)name, ""));
        this.setOptionValueForce(BingoOptions.PLAYER_GAMEMODE_AFTER_GAME, name -> BingoOptions.ConfigGamemode.valueOf(config.getString((String)name, "SURVIVAL")));
        this.setOptionValueForce(BingoOptions.VOTE_USING_COMMANDS_ONLY, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.SELECT_TEAMS_USING_COMMANDS_ONLY, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.DISABLE_SCOREBOARD_SIDEBAR, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.USE_INCLUDED_RESOURCE_PACK, name -> false);
        this.setOptionValueForce(BingoOptions.USE_MAP_RENDERER, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.SHOW_UNIQUE_ADVANCEMENT_ITEMS, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.SHOW_UNIQUE_STATISTIC_ITEMS, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.ENABLE_DEBUG_LOGGING, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.DISABLE_CLIENT_MOD, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.SINGLE_PLAYER_TEAMS, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.MINIMUM_PLAYER_COUNT, name -> config.getInt((String)name, 4));
        this.setOptionValueForce(BingoOptions.PLAYER_WAIT_TIME, name -> config.getInt((String)name, 30));
        this.setOptionValueForce(BingoOptions.GAME_RESTART_TIME, name -> config.getInt((String)name, 20));
        this.setOptionValueForce(BingoOptions.USE_VOTE_SYSTEM, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.PREVENT_PLAYER_GRIEFING, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.TELEPORT_TO_LOBBY_AFTER_GAME, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.TELEPORT_TO_LOBBY_DELAY, name -> config.getDouble((String)name, 10.0));
        this.setOptionValueForce(BingoOptions.TELEPORT_TO_LOBBY_SPREAD, name -> config.getInt((String)name, 5));
        this.setOptionValueForce(BingoOptions.VOTE_LIST, name -> new VoteList(config.getList("voteList.gamemodes", TagDataType.STRING), config.getList("voteList.kits", TagDataType.STRING), config.getList("voteList.cards", TagDataType.STRING), config.getList("voteList.cardsizes", TagDataType.STRING)));
        this.setOptionValueForce(BingoOptions.STARTING_COUNTDOWN_TIME, name -> config.getInt((String)name, 10));
        this.setOptionValueForce(BingoOptions.TELEPORT_MAX_DISTANCE, name -> config.getInt((String)name, 1000000));
        this.setOptionValueForce(BingoOptions.PLAYER_TELEPORT_STRATEGY, name -> BingoOptions.PlayerTeleportStrategy.valueOf(config.getString((String)name, "ALL")));
        this.setOptionValueForce(BingoOptions.TELEPORT_AFTER_DEATH, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.TELEPORT_AFTER_DEATH_PERIOD, name -> config.getInt((String)name, 60));
        this.setOptionValueForce(BingoOptions.GO_UP_WAND_UP_DISTANCE, name -> config.getInt((String)name, 75));
        this.setOptionValueForce(BingoOptions.GO_UP_WAND_DOWN_DISTANCE, name -> config.getInt((String)name, 5));
        this.setOptionValueForce(BingoOptions.GO_UP_WAND_COOLDOWN, name -> config.getDouble((String)name, 5.0));
        this.setOptionValueForce(BingoOptions.GO_UP_WAND_PLATFORM_LIFETIME, name -> config.getInt((String)name, 10));
        this.setOptionValueForce(BingoOptions.GRACE_PERIOD, name -> config.getInt((String)name, 30));
        this.setOptionValueForce(BingoOptions.REMOVE_TASK_ITEMS, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.ENABLE_TEAM_CHAT, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.KEEP_SCOREBOARD_VISIBLE, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.SHOW_PLAYER_IN_SCOREBOARD, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.DISABLE_ADVANCEMENTS, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.DISABLE_STATISTICS, name -> config.getBoolean((String)name, false));
        this.setOptionValueForce(BingoOptions.END_GAME_WITHOUT_TEAMS, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.HOTSWAP_CONFIG, name -> new HotswapConfig(config.getInt(name + "minimumExpirationTime", 3), config.getInt(name + "maximumExpirationTime", 20), config.getInt(name + "recoverTime", 10), config.getBoolean(name + "showExpirationAsDurability", true)));
        this.setOptionValueForce(BingoOptions.ALLOW_VIEWING_ALL_CARDS, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.SAVE_PLAYER_INFORMATION, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.LOAD_PLAYER_INFORMATION_STRATEGY, name -> BingoOptions.LoadPlayerInformationStrategy.valueOf(config.getString((String)name, "AFTER_LEAVING_WORLD")));
        this.setOptionValueForce(BingoOptions.DEFAULT_WORLDS, name -> new ConfigurationOption.StringList(config.getList((String)name, TagDataType.STRING)));
        this.setOptionValueForce(BingoOptions.CLEAR_DEFAULT_WORLDS, name -> config.getBoolean((String)name, true));
        this.setOptionValueForce(BingoOptions.CUSTOM_WORLD_GENERATION, name -> config.getString((String)name, "null"));
    }

    public void reload() {
        this.config.load();
    }

    @NotNull
    public <DataType> DataType getOptionValue(@Nullable ConfigurationOption<DataType> option) {
        if (!this.options.containsKey(option)) {
            if (option != null) {
                ConsoleMessenger.bug("Cannot read config option " + option.getConfigName(), (Object)this);
            } else {
                ConsoleMessenger.bug("Config option does not exist, throwing error!", (Object)this);
            }
            throw new IllegalArgumentException();
        }
        return (DataType)this.options.get(option);
    }

    public <DataType> void setOptionValue(@NotNull ConfigurationOption<DataType> option, DataType value) {
        if (option.isLocked()) {
            return;
        }
        this.options.put(option, value);
    }

    public <DataType> boolean setOptionValueFromString(@NotNull ConfigurationOption<DataType> option, String value) {
        Optional<DataType> someValue = option.fromString(value);
        if (someValue.isPresent()) {
            DataType val = someValue.get();
            this.setOptionValue(option, val);
            option.toDataStorage(this.config, val);
            this.config.saveChanges();
            return true;
        }
        return false;
    }

    public <T> void setOptionValueForce(ConfigurationOption<T> option, Function<String, T> defaultValue) {
        this.options.put(option, defaultValue.apply(option.getConfigName()));
    }

    @NotNull
    public Optional<ConfigurationOption<?>> getOptionFromName(String name) {
        for (ConfigurationOption<?> o : this.options.keySet()) {
            if (!o.getConfigName().equals(name)) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }

    public Set<ConfigurationOption<?>> getAvailableOptions() {
        return this.options.keySet();
    }

    public record HotswapConfig(int minimumExpiration, int maximumExpiration, int recoveryTime, boolean showExpirationAsDurability) {
    }

    public record VoteList(List<String> gamemodes, List<String> kits, List<String> cards, List<String> cardSizes) {
        public boolean isEmpty() {
            return this.gamemodes.isEmpty() && this.kits.isEmpty() && this.cards.isEmpty() && this.cardSizes.isEmpty();
        }
    }
}

