/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.config;

import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BooleanOption;
import io.github.steaf23.bingoreloaded.data.config.ConfigurationOption;
import io.github.steaf23.bingoreloaded.data.config.DoubleOption;
import io.github.steaf23.bingoreloaded.data.config.EnumOption;
import io.github.steaf23.bingoreloaded.data.config.IntegerOption;
import io.github.steaf23.bingoreloaded.data.config.NonSerializableOption;
import io.github.steaf23.bingoreloaded.data.config.StringOption;
import io.github.steaf23.bingoreloaded.data.config.StringOptionAllowEmpty;

public class BingoOptions {
    public static final ConfigurationOption<PluginConfiguration> CONFIGURATION = new EnumOption<PluginConfiguration>("configuration", PluginConfiguration.class, PluginConfiguration.SINGULAR).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<String> DEFAULT_WORLD_NAME = new StringOption("defaultWorldName").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<String> LANGUAGE = new StringOption("language").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<Boolean> SAVE_PLAYER_STATISTICS = new BooleanOption("savePlayerStatistics");
    public static final ConfigurationOption<String> SEND_COMMAND_AFTER_GAME_ENDS = new StringOptionAllowEmpty("sendCommandAfterGameEnds");
    public static final ConfigurationOption<String> SEND_COMMAND_BEFORE_GAME_STARTS = new StringOptionAllowEmpty("sendCommandBeforeGameStarts");
    public static final ConfigurationOption<ConfigGamemode> PLAYER_GAMEMODE_AFTER_GAME = new EnumOption<ConfigGamemode>("playerGamemodeAfterGame", ConfigGamemode.class, ConfigGamemode.SURVIVAL);
    public static final ConfigurationOption<Boolean> VOTE_USING_COMMANDS_ONLY = new BooleanOption("voteUsingCommandsOnly");
    public static final ConfigurationOption<Boolean> SELECT_TEAMS_USING_COMMANDS_ONLY = new BooleanOption("selectTeamsUsingCommandsOnly");
    public static final ConfigurationOption<Boolean> DISABLE_SCOREBOARD_SIDEBAR = new BooleanOption("disableScoreboardSidebar").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SESSION);
    public static final ConfigurationOption<Boolean> USE_INCLUDED_RESOURCE_PACK = new BooleanOption("useIncludedResourcePack").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART).lock();
    public static final ConfigurationOption<Boolean> USE_MAP_RENDERER = new BooleanOption("useMapRenderer").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> SHOW_UNIQUE_ADVANCEMENT_ITEMS = new BooleanOption("showUniqueAdvancementItems").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> SHOW_UNIQUE_STATISTIC_ITEMS = new BooleanOption("showUniqueStatisticItems").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> ENABLE_DEBUG_LOGGING = new BooleanOption("enableDebugLogging");
    public static final ConfigurationOption<Boolean> DISABLE_CLIENT_MOD = new BooleanOption("disableCompanionMod").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<Boolean> SINGLE_PLAYER_TEAMS = new BooleanOption("singlePlayerTeams").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SESSION);
    public static final ConfigurationOption<Integer> MINIMUM_PLAYER_COUNT = new IntegerOption("minimumPlayerCount").withMin(0);
    public static final ConfigurationOption<Integer> PLAYER_WAIT_TIME = new IntegerOption("playerWaitTime").withMin(0).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Integer> GAME_RESTART_TIME = new IntegerOption("gameRestartTime").withMin(0).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> USE_VOTE_SYSTEM = new BooleanOption("useVoteSystem");
    public static final ConfigurationOption<Boolean> PREVENT_PLAYER_GRIEFING = new BooleanOption("preventPlayerGriefing");
    public static final ConfigurationOption<Boolean> TELEPORT_TO_LOBBY_AFTER_GAME = new BooleanOption("teleportToLobbyAfterGame.enabled");
    public static final ConfigurationOption<Double> TELEPORT_TO_LOBBY_DELAY = new DoubleOption("teleportToLobbyAfterGame.delaySeconds");
    public static final ConfigurationOption<Integer> TELEPORT_TO_LOBBY_SPREAD = new IntegerOption("teleportToLobbyAfterGame.spread");
    public static final ConfigurationOption<BingoConfigurationData.VoteList> VOTE_LIST = new NonSerializableOption<BingoConfigurationData.VoteList>("voteList");
    public static final ConfigurationOption<Integer> STARTING_COUNTDOWN_TIME = new IntegerOption("startingCountdownTime").withMin(0).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Integer> TELEPORT_MAX_DISTANCE = new IntegerOption("teleportMaxDistance").withMin(0).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<PlayerTeleportStrategy> PLAYER_TELEPORT_STRATEGY = new EnumOption<PlayerTeleportStrategy>("playerTeleportStrategy", PlayerTeleportStrategy.class, PlayerTeleportStrategy.ALL).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> TELEPORT_AFTER_DEATH = new BooleanOption("teleportAfterDeath");
    public static final ConfigurationOption<Integer> TELEPORT_AFTER_DEATH_PERIOD = new IntegerOption("teleportAfterDeathPeriod").withMin(0).withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Integer> GO_UP_WAND_UP_DISTANCE = new IntegerOption("GoUpWand.upDistance");
    public static final ConfigurationOption<Integer> GO_UP_WAND_DOWN_DISTANCE = new IntegerOption("GoUpWand.downDistance");
    public static final ConfigurationOption<Double> GO_UP_WAND_COOLDOWN = new DoubleOption("GoUpWand.cooldown");
    public static final ConfigurationOption<Integer> GO_UP_WAND_PLATFORM_LIFETIME = new IntegerOption("GoUpWand.platformLifetime").withMin(0);
    public static final ConfigurationOption<Integer> GRACE_PERIOD = new IntegerOption("gracePeriod").withMin(0);
    public static final ConfigurationOption<Boolean> REMOVE_TASK_ITEMS = new BooleanOption("removeTaskItems");
    public static final ConfigurationOption<Boolean> ENABLE_TEAM_CHAT = new BooleanOption("enableTeamChat").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<Boolean> KEEP_SCOREBOARD_VISIBLE = new BooleanOption("keepScoreboardVisible").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> SHOW_PLAYER_IN_SCOREBOARD = new BooleanOption("showPlayerInScoreboard").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SESSION);
    public static final ConfigurationOption<Boolean> DISABLE_ADVANCEMENTS = new BooleanOption("disableAdvancements").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<Boolean> DISABLE_STATISTICS = new BooleanOption("disableStatistics").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);
    public static final ConfigurationOption<Boolean> END_GAME_WITHOUT_TEAMS = new BooleanOption("endGameWithoutTeams");
    public static final ConfigurationOption<BingoConfigurationData.HotswapConfig> HOTSWAP_CONFIG = new NonSerializableOption<BingoConfigurationData.HotswapConfig>("hotswapMode");
    public static final ConfigurationOption<Boolean> ALLOW_VIEWING_ALL_CARDS = new BooleanOption("allowViewingAllCards").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> SAVE_PLAYER_INFORMATION = new BooleanOption("savePlayerInformation");
    public static final ConfigurationOption<LoadPlayerInformationStrategy> LOAD_PLAYER_INFORMATION_STRATEGY = new EnumOption<LoadPlayerInformationStrategy>("loadPlayerInformationStrategy", LoadPlayerInformationStrategy.class, LoadPlayerInformationStrategy.AFTER_LEAVING_WORLD);
    public static final ConfigurationOption<ConfigurationOption.StringList> DEFAULT_WORLDS = new NonSerializableOption("defaultWorlds").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_GAME);
    public static final ConfigurationOption<Boolean> CLEAR_DEFAULT_WORLDS = new BooleanOption("clearDefaultWorlds");
    public static final ConfigurationOption<String> CUSTOM_WORLD_GENERATION = new StringOption("customWorldGeneration").withEditUpdate(ConfigurationOption.EditUpdateTime.AFTER_SERVER_RESTART);

    public static enum PluginConfiguration {
        SINGULAR,
        MULTIPLE;

    }

    public static enum ConfigGamemode {
        NONE,
        SURVIVAL,
        ADVENTURE,
        CREATIVE,
        SPECTATOR;

    }

    public static enum PlayerTeleportStrategy {
        ALONE,
        TEAM,
        ALL,
        NONE;

    }

    public static enum LoadPlayerInformationStrategy {
        AFTER_GAME,
        AFTER_LEAVING_WORLD;

    }
}

