/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.config;

import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationOption<Data> {
    @NotNull
    private final String configName;
    private EditUpdateTime editUpdate = EditUpdateTime.IMMEDIATE;
    private boolean locked = false;

    public ConfigurationOption(@NotNull String configName) {
        this.configName = configName;
    }

    @NotNull
    public String getConfigName() {
        return this.configName;
    }

    public EditUpdateTime getEditUpdateTime() {
        return this.editUpdate;
    }

    public ConfigurationOption<Data> withEditUpdate(EditUpdateTime editUpdate) {
        this.editUpdate = editUpdate;
        return this;
    }

    public ConfigurationOption<Data> lock() {
        this.locked = true;
        return this;
    }

    public boolean canBeEdited() {
        return this.getEditUpdateTime() != EditUpdateTime.IMPOSSIBLE && !this.isLocked();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public abstract Optional<Data> fromString(String var1);

    public abstract void toDataStorage(DataStorage var1, @NotNull Data var2);

    public static enum EditUpdateTime {
        IMMEDIATE,
        AFTER_GAME,
        AFTER_SERVER_RESTART,
        AFTER_SESSION,
        IMPOSSIBLE;

    }

    public static class StringList
    extends ArrayList<String> {
        public StringList(List<String> in) {
            this.addAll(in);
        }
    }
}

