/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.config;

import io.github.steaf23.bingoreloaded.data.config.ConfigurationOption;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class IntegerOption
extends ConfigurationOption<Integer> {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntegerOption(String configName) {
        super(configName);
    }

    public IntegerOption withMin(int min) {
        this.min = min;
        return this;
    }

    public IntegerOption withMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public Optional<Integer> fromString(String value) {
        try {
            int val = Integer.parseInt(value);
            return Optional.of(Math.clamp((long)val, this.min, this.max));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public void toDataStorage(DataStorage storage, @NotNull Integer value) {
        storage.setInt(this.getConfigName(), value);
    }
}

