/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.world;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.helper.ResourceFileHelper;
import io.github.steaf23.bingoreloaded.data.world.WorldGroup;
import io.github.steaf23.bingoreloaded.lib.api.DimensionType;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldOptions;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.io.File;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldData {
    private final ServerSoftware platform;
    private final Key generationOptions;

    public WorldData(ServerSoftware platform, @Nullable Key generationOptions) {
        this.platform = platform;
        this.generationOptions = generationOptions;
    }

    public boolean clearWorlds() {
        String worldFolder = this.getWorldsFolder();
        File worldsFolderDir = FileUtils.getFile(worldFolder);
        if (!worldsFolderDir.exists() && !worldsFolderDir.mkdirs()) {
            return false;
        }
        int removeCount = 0;
        for (File f : worldsFolderDir.listFiles(File::isDirectory)) {
            String worldName;
            if (f.equals(worldsFolderDir) || !this.destroyWorld(worldName = f.getName())) continue;
            ++removeCount;
        }
        ConsoleMessenger.log(Component.text("Removed " + removeCount + " bingo worlds on startup").color(NamedTextColor.LIGHT_PURPLE));
        return true;
    }

    public WorldGroup createWorldGroup(String worldName) {
        WorldHandle overworld = BingoReloaded.runtime().createBingoWorld(worldName, this.generationOptions);
        if (overworld == null) {
            overworld = this.createWorld(worldName, DimensionType.OVERWORLD);
        }
        WorldHandle nether = this.createWorld(worldName + "_nether", DimensionType.NETHER);
        WorldHandle end = this.createWorld(worldName + "_the_end", DimensionType.THE_END);
        return new WorldGroup(this.platform, worldName, overworld.uniqueId(), nether.uniqueId(), end.uniqueId());
    }

    @Nullable
    public WorldGroup getWorldGroup(String worldName) {
        WorldHandle overworld = this.platform.getWorld(this.getWorldsFolder() + worldName);
        WorldHandle nether = this.platform.getWorld(this.getWorldsFolder() + worldName + "_nether");
        WorldHandle theEnd = this.platform.getWorld(this.getWorldsFolder() + worldName + "_the_end");
        if (overworld == null) {
            ConsoleMessenger.error("Could not fetch world group; " + worldName + " does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        if (nether == null) {
            ConsoleMessenger.error("Could not fetch world group; " + worldName + "_nether does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        if (theEnd == null) {
            ConsoleMessenger.error("Could not fetch world group; " + worldName + "_the_end does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        return new WorldGroup(this.platform, worldName, overworld.uniqueId(), nether.uniqueId(), theEnd.uniqueId());
    }

    public boolean destroyWorldGroup(@NotNull WorldGroup worldGroup) {
        boolean success = this.destroyWorld(worldGroup.worldName());
        success = success && this.destroyWorld(worldGroup.worldName() + "_nether");
        success = success && this.destroyWorld(worldGroup.worldName() + "_the_end");
        return success;
    }

    private String getWorldsFolder() {
        return this.platform.getDataFolder().getPath().replace("\\", "/") + "/worlds/";
    }

    private WorldHandle createWorld(String worldName, @NotNull DimensionType dimension) {
        String worldFolder = this.getWorldsFolder();
        WorldOptions options = new WorldOptions(worldFolder + worldName, dimension);
        return this.platform.createWorld(options);
    }

    private boolean destroyWorld(String worldName) {
        boolean stillLoaded;
        String worldsFolder = this.getWorldsFolder();
        WorldHandle bukkitWorld = this.platform.getWorld(worldsFolder + worldName);
        if (bukkitWorld == null) {
            if (!ResourceFileHelper.deleteFolderRecurse(worldsFolder + worldName)) {
                ConsoleMessenger.bug("Could not remove folder for " + worldName + ", cannot find the folder of this world (it might already be removed) or the folder could not be accessed", (Object)this.platform);
            }
            return false;
        }
        UUID worldId = bukkitWorld.uniqueId();
        boolean worldUnloaded = this.platform.unloadWorld(bukkitWorld, false);
        WorldHandle unloadedWorld = this.platform.getWorld(worldId);
        boolean bl = stillLoaded = unloadedWorld != null || !worldUnloaded;
        if (stillLoaded) {
            ConsoleMessenger.error("Could not remove " + worldName + ", world could not be unloaded (Maybe there are still players present?).");
            return false;
        }
        if (!ResourceFileHelper.deleteFolderRecurse(worldsFolder + worldName)) {
            ConsoleMessenger.bug("Could not remove folder for " + worldName + ", cannot find the folder of this world (it might already be removed) or the folder could not be accessed", (Object)this.platform);
        }
        return true;
    }
}

