/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.data.world;

import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public record WorldGroup(ServerSoftware platform, String worldName, UUID overworldId, UUID netherId, UUID endId) {
    public void teleportPlayer(PlayerHandle player) {
        player.teleportBlocking(this.platform.getWorld(this.overworldId).spawnPoint());
    }

    @Nullable
    public WorldHandle getOverworld() {
        return this.overworldId == null ? null : this.platform.getWorld(this.overworldId);
    }

    @Nullable
    public WorldHandle getNetherWorld() {
        return this.netherId == null ? null : this.platform.getWorld(this.netherId);
    }

    @Nullable
    public WorldHandle getEndWorld() {
        return this.endId == null ? null : this.platform.getWorld(this.endId);
    }

    public boolean hasWorld(UUID uuid) {
        return this.overworldId.equals(uuid) || this.netherId.equals(uuid) || this.endId.equals(uuid);
    }

    public Set<PlayerHandle> getPlayers() {
        HashSet<PlayerHandle> players = new HashSet<PlayerHandle>();
        if (this.getOverworld() != null) {
            players.addAll(this.getOverworld().players());
        }
        if (this.getNetherWorld() != null) {
            players.addAll(this.getNetherWorld().players());
        }
        if (this.getEndWorld() != null) {
            players.addAll(this.getEndWorld().players());
        }
        return players;
    }
}

