/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.BingoEvents;
import io.github.steaf23.bingoreloaded.api.TeamDisplay;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.BingoLobby;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.data.world.WorldGroup;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.gameloop.phase.PostGamePhase;
import io.github.steaf23.bingoreloaded.gameloop.phase.PregameLobby;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteTicket;
import io.github.steaf23.bingoreloaded.lib.api.DimensionType;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.PlayerGamemode;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.event.EventResults;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.world.BlockHelper;
import io.github.steaf23.bingoreloaded.menu.BingoGameInfoMenu;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.team.BasicTeamManager;
import io.github.steaf23.bingoreloaded.player.team.SoloTeamManager;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.BingoSettingsBuilder;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoSession
implements ForwardingAudience {
    public BingoSettingsBuilder settingsBuilder;
    public final BingoGameInfoMenu gameInfoMenu;
    public final TeamManager teamManager;
    private final GameManager gameManager;
    private final BingoConfigurationData config;
    private final TeamDisplay teamDisplay;
    private final WorldGroup worlds;
    private GamePhase phase;

    public BingoSession(GameManager gameManager, @NotNull WorldGroup worlds, BingoConfigurationData config) {
        this.gameManager = gameManager;
        this.worlds = worlds;
        this.config = config;
        boolean showPlayerInScoreboard = config.getOptionValue(BingoOptions.SHOW_PLAYER_IN_SCOREBOARD);
        this.gameInfoMenu = new BingoGameInfoMenu(this, showPlayerInScoreboard);
        this.settingsBuilder = new BingoSettingsBuilder(this);
        this.teamManager = config.getOptionValue(BingoOptions.SINGLE_PLAYER_TEAMS) != false ? new SoloTeamManager(this) : new BasicTeamManager(this);
        this.teamDisplay = gameManager.getRuntime().createTeamDisplay(this);
        this.phase = null;
        gameManager.getPlatform().runTask(10L, t -> {
            for (PlayerHandle playerHandle : PlatformResolver.get().getOnlinePlayers()) {
                if (!this.hasPlayer(playerHandle)) continue;
                this.addPlayer(playerHandle);
            }
        });
        this.prepareNextGame();
    }

    public boolean isRunning() {
        return this.phase instanceof BingoGame;
    }

    public boolean canPlayersViewCard() {
        return this.phase.canViewCard();
    }

    public GamePhase phase() {
        return this.phase;
    }

    public boolean startGame() {
        return this.startGame(null);
    }

    public boolean startGame(@Nullable WorldPosition atPosition) {
        GamePhase gamePhase = this.phase;
        if (!(gamePhase instanceof PregameLobby)) {
            ConsoleMessenger.error("Cannot start a game on this world if it is not in the lobby phase!");
            return false;
        }
        PregameLobby lobby = (PregameLobby)gamePhase;
        BingoSettingsBuilder gameSettings = this.determineSettingsByVote(lobby);
        BingoCardData cardsData = new BingoCardData();
        BingoSettings settings = this.settingsBuilder.view();
        if (!cardsData.getCardNames().contains(settings.card())) {
            BingoMessage.NO_CARD.sendToAudience((Audience)this, (TextColor)NamedTextColor.RED, Component.text(settings.card()));
            return false;
        }
        if (this.teamManager.getParticipantCount() == 0) {
            ConsoleMessenger.log("Could not start bingo since no players have joined!", this.worlds.worldName());
            this.teamManager.reset();
            return false;
        }
        this.teamManager.setup();
        this.gameInfoMenu.updateTeamScores();
        this.getGameManager().getRuntime().gameDisplay().update(this.gameInfoMenu);
        this.phase.end();
        this.phase = new BingoGame(this.gameManager.getPlatform(), this, gameSettings == null ? settings : gameSettings.view(), this.config, this::onGameEnded, atPosition);
        this.phase.setup();
        return true;
    }

    public void endGame() {
        if (!this.isRunning()) {
            return;
        }
        this.phase.end();
    }

    public void pauseAutomaticStart() {
        GamePhase gamePhase = this.phase;
        if (!(gamePhase instanceof PregameLobby)) {
            return;
        }
        PregameLobby lobbyPhase = (PregameLobby)gamePhase;
        lobbyPhase.playerCountTimerTogglePause();
    }

    public void prepareNextGame() {
        this.teamManager.reset();
        this.gameManager.prepareNextBingoGame(this);
        if (this.phase != null) {
            this.phase.end();
        }
        this.phase = new PregameLobby(this, this.config);
        this.phase.setup();
        this.getOverworld().players().forEach(p -> {
            this.getGameManager().getRuntime().getClientManager().updateCard((PlayerHandle)p, null);
            if (this.teamManager.getPlayerAsParticipant((PlayerHandle)p) == null) {
                this.teamManager.addMemberToTeam(new BingoPlayer((PlayerHandle)p, this), "auto");
            }
        });
    }

    public void removeParticipant(@NotNull BingoParticipant player) {
        this.teamManager.removeMemberFromTeam(player);
    }

    public void onGameEnded() {
        PlayerGamemode mode;
        BingoLobby lobby;
        int gameRestartTime = this.config.getOptionValue(BingoOptions.GAME_RESTART_TIME);
        if (this.config.getOptionValue(BingoOptions.TELEPORT_TO_LOBBY_AFTER_GAME).booleanValue() && (lobby = this.gameManager.getLobbyData().getCreatedLobby()) != null && lobby.spawnPosition() != null) {
            double delaySeconds = this.config.getOptionValue(BingoOptions.TELEPORT_TO_LOBBY_DELAY);
            int spread = this.config.getOptionValue(BingoOptions.TELEPORT_TO_LOBBY_SPREAD);
            if ((delaySeconds = Math.min(delaySeconds, (double)gameRestartTime)) > 0.0) {
                this.gameManager.getPlatform().runTask((long)(delaySeconds * 20.0), t -> this.getPlayersInWorld().forEach(p -> {
                    WorldPosition pos = BlockHelper.getRandomPosWithinRange(lobby.spawnPosition(), spread, spread);
                    p.teleportAsync(pos);
                }));
            } else {
                this.getPlayersInWorld().forEach(p -> {
                    WorldPosition pos = BlockHelper.getRandomPosWithinRange(lobby.spawnPosition(), spread, spread);
                    p.teleportAsync(pos);
                });
            }
        }
        BingoOptions.ConfigGamemode gamemode = this.config.getOptionValue(BingoOptions.PLAYER_GAMEMODE_AFTER_GAME);
        switch (gamemode) {
            case SURVIVAL: {
                PlayerGamemode playerGamemode = PlayerGamemode.SURVIVAL;
                break;
            }
            case SPECTATOR: {
                PlayerGamemode playerGamemode = PlayerGamemode.SPECTATOR;
                break;
            }
            case ADVENTURE: {
                PlayerGamemode playerGamemode = PlayerGamemode.ADVENTURE;
                break;
            }
            case CREATIVE: {
                PlayerGamemode playerGamemode = PlayerGamemode.CREATIVE;
                break;
            }
            default: {
                PlayerGamemode playerGamemode = mode = null;
            }
        }
        if (mode != null) {
            this.getPlayersInWorld().forEach(p -> p.setGamemode(mode));
        }
        this.phase = new PostGamePhase(this, gameRestartTime);
        this.phase.setup();
    }

    public void onSettingUpdated(BingoSettings newSettings) {
        this.phase.handleSettingsUpdated(newSettings);
        this.teamManager.handleSettingsUpdated(newSettings);
    }

    public void addPlayer(PlayerHandle player) {
        this.onPlayerJoinedSessionWorld(player);
        if (this.teamManager.getPlayerAsParticipant(player) == null || !this.isRunning()) {
            BingoLobby lobby = this.gameManager.getLobbyData().getCreatedLobby();
            int spread = this.config.getOptionValue(BingoOptions.TELEPORT_TO_LOBBY_SPREAD);
            if (lobby != null && lobby.spawnPosition() != null) {
                player.teleportAsync(BlockHelper.getRandomPosWithinRange(lobby.spawnPosition(), spread, spread));
            }
        }
        BingoReloaded.sendResourcePack(player);
    }

    public void removePlayer(PlayerHandle player) {
        this.onPlayerLeftSessionWorld(player);
    }

    public EventResult<?> handlePlayerDroppedStack(PlayerHandle player, StackHandle stack) {
        if (PlayerKit.CARD_ITEM.isCompareKeyEqual(stack) || PlayerKit.WAND_ITEM.isCompareKeyEqual(stack) || PlayerKit.VOTE_ITEM.isCompareKeyEqual(stack) || PlayerKit.TEAM_ITEM.isCompareKeyEqual(stack)) {
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    public void onPlayerJoinedSessionWorld(PlayerHandle player) {
        this.gameManager.getPlatform().runTask(t -> {
            this.teamManager.handlePlayerJoinedSessionWorld(player);
            this.phase.handlePlayerJoinedSessionWorld(player);
            if (this.isRunning()) {
                this.getGameManager().getRuntime().gameDisplay().addPlayer(player);
            }
            this.teamDisplay.update();
        });
    }

    public void onPlayerLeftSessionWorld(PlayerHandle player) {
        this.teamDisplay.clearTeamsForPlayer(player);
        this.getGameManager().getRuntime().getClientManager().updateCard(player, null);
        this.getGameManager().getPlatform().runTask(t -> {
            this.teamManager.handlePlayerLeftSessionWorld(player);
            this.phase.handlePlayerLeftSessionWorld(player);
            player.clearAllEffects();
            if (this.isRunning()) {
                BingoMessage.LEAVE.sendToAudience((Audience)player, new Component[0]);
            }
            this.getGameManager().getRuntime().gameDisplay().removePlayer(player);
            this.teamDisplay.update();
            if (!this.config.getOptionValue(BingoOptions.END_GAME_WITHOUT_TEAMS).booleanValue()) {
                return;
            }
            if (this.teamManager.getActiveTeams().getOnlineTeamCount() <= 1L || this.teamManager.getActiveTeams().getAllOnlineParticipants().isEmpty()) {
                if (this.isRunning()) {
                    ConsoleMessenger.log(Component.text("Ending game because there is no competition anymore.").color(NamedTextColor.LIGHT_PURPLE), Component.text(this.worlds.worldName()));
                }
                this.endGame();
            }
        });
    }

    public void onParticipantJoinedTeam(BingoEvents.TeamParticipantEvent event) {
        this.phase.handleParticipantJoinedTeam(event);
        this.teamDisplay.update();
    }

    public void onParticipantLeftTeam(BingoEvents.TeamParticipantEvent event) {
        this.phase.handleParticipantLeftTeam(event);
        this.teamDisplay.update();
    }

    public EventResult<EventResults.PlayerMoveResult> handlePlayerPortalEvent(PlayerHandle player, WorldPosition fromPos, @NotNull WorldPosition toPos) {
        WorldHandle origin = fromPos.world();
        WorldHandle target = toPos.world();
        WorldPosition targetLocation = new WorldPosition(toPos);
        if (origin.uniqueId().equals(this.worlds.overworldId())) {
            if (target.dimension() == DimensionType.NETHER) {
                targetLocation.setWorld(this.worlds.getNetherWorld());
            } else if (target.dimension() == DimensionType.THE_END) {
                targetLocation.setWorld(this.worlds.getEndWorld());
            } else {
                ConsoleMessenger.bug("Could not catch player going through portal", (Object)this);
            }
        } else if (origin.uniqueId().equals(this.worlds.netherId())) {
            targetLocation.setWorld(this.worlds.getOverworld());
        } else if (origin.uniqueId().equals(this.worlds.endId())) {
            if (target.dimension() == DimensionType.OVERWORLD) {
                targetLocation.setWorld(this.worlds.getOverworld());
            } else if (target.dimension() == DimensionType.THE_END) {
                targetLocation.setWorld(this.worlds.getEndWorld());
            } else {
                ConsoleMessenger.bug("Could not catch player going through portal", (Object)this);
            }
        }
        return EventResults.playerMoveResult(false, true, targetLocation);
    }

    public EventResult<?> handlePlayerBlockBreak(PlayerHandle player, WorldPosition position, ItemType block) {
        if (!this.isRunning() && this.config.getOptionValue(BingoOptions.PREVENT_PLAYER_GRIEFING).booleanValue() && !player.hasPermission("bingo.admin")) {
            BingoMessage.NO_GRIEFING.sendToAudience((Audience)player, new Component[0]);
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    public EventResult<?> handlePlayerBlockPlace(PlayerHandle player, WorldPosition position, ItemType block) {
        if (!this.isRunning() && this.config.getOptionValue(BingoOptions.PREVENT_PLAYER_GRIEFING).booleanValue() && !player.hasPermission("bingo.admin")) {
            BingoMessage.NO_GRIEFING.sendToAudience((Audience)player, new Component[0]);
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    public WorldHandle getOverworld() {
        return this.worlds.getOverworld();
    }

    public boolean ownsWorld(@NotNull WorldHandle world) {
        return this.worlds.hasWorld(world.uniqueId());
    }

    public BingoConfigurationData getPluginConfig() {
        return this.config;
    }

    private BingoSettingsBuilder determineSettingsByVote(PregameLobby lobby) {
        if (!this.config.getOptionValue(BingoOptions.USE_VOTE_SYSTEM).booleanValue()) {
            return null;
        }
        VoteTicket voteResult = VoteTicket.getVoteResult(lobby.getAllVotes());
        if (voteResult.isEmpty()) {
            return null;
        }
        BingoSettingsBuilder result = this.settingsBuilder.applyVoteResult(voteResult);
        Consumer<VoteCategory> sendVoteMessage = category -> BingoMessage.VOTE_WON.sendToAudience((Audience)this, category.asComponent(), category.getValueComponent(voteResult.getVote((VoteCategory<?>)category)).decorate(TextDecoration.BOLD));
        this.sendMessage(Component.text(" "));
        if (voteResult.containsCategory(VoteTicket.CATEGORY_GAMEMODE)) {
            sendVoteMessage.accept(VoteTicket.CATEGORY_GAMEMODE);
        }
        if (voteResult.containsCategory(VoteTicket.CATEGORY_KIT)) {
            sendVoteMessage.accept(VoteTicket.CATEGORY_KIT);
        }
        if (voteResult.containsCategory(VoteTicket.CATEGORY_CARD)) {
            sendVoteMessage.accept(VoteTicket.CATEGORY_CARD);
        }
        if (voteResult.containsCategory(VoteTicket.CATEGORY_CARDSIZE)) {
            sendVoteMessage.accept(VoteTicket.CATEGORY_CARDSIZE);
        }
        this.sendMessage(Component.text(" "));
        return result;
    }

    public boolean hasPlayer(@NotNull PlayerHandle p) {
        return this.ownsWorld(p.world());
    }

    @Nullable
    public GamePhase getPhase() {
        return this.phase;
    }

    public void destroy() {
        this.teamDisplay.reset();
    }

    public Set<PlayerHandle> getPlayersInWorld() {
        return this.worlds.getPlayers();
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.teamManager.getParticipants();
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }
}

