/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop;

import io.github.steaf23.bingoreloaded.api.BingoEventListener;
import io.github.steaf23.bingoreloaded.data.BingoLobbyData;
import io.github.steaf23.bingoreloaded.data.PlayerSerializationData;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.data.helper.SerializablePlayer;
import io.github.steaf23.bingoreloaded.data.world.WorldData;
import io.github.steaf23.bingoreloaded.data.world.WorldGroup;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameManager {
    protected final Map<String, BingoSession> sessions;
    private final BingoReloadedRuntime runtime;
    private final BingoConfigurationData config;
    private final PlayerSerializationData playerData;
    private final BingoEventListener eventListener;
    private final WorldData worldData;
    private final BingoLobbyData lobbyData;
    private boolean teleportingPlayer;

    public GameManager(@NotNull BingoReloadedRuntime runtime, BingoConfigurationData config) {
        this.runtime = runtime;
        this.config = config;
        this.lobbyData = new BingoLobbyData();
        String settingsName = config.getOptionValue(BingoOptions.CUSTOM_WORLD_GENERATION);
        Key generationSettings = settingsName.equals("null") ? null : Key.key(settingsName);
        this.worldData = new WorldData(runtime.getServerSoftware(), generationSettings);
        this.sessions = new HashMap<String, BingoSession>();
        this.playerData = new PlayerSerializationData();
        this.teleportingPlayer = false;
        this.eventListener = new BingoEventListener(this, config.getOptionValue(BingoOptions.DISABLE_ADVANCEMENTS), config.getOptionValue(BingoOptions.DISABLE_STATISTICS));
        if (config.getOptionValue(BingoOptions.CLEAR_DEFAULT_WORLDS).booleanValue()) {
            this.worldData.clearWorlds();
        }
    }

    public void setup(List<String> worldNames) {
        for (String world : worldNames) {
            this.createSession(world);
        }
        ConsoleMessenger.log("Created world(s) " + String.valueOf(worldNames));
    }

    public boolean createSession(String sessionName) {
        if (this.sessions.containsKey(sessionName)) {
            ConsoleMessenger.error("An instance of Bingo already exists in world '" + sessionName + "'!");
            return false;
        }
        BingoSession session = new BingoSession(this, this.worldData.createWorldGroup(sessionName), this.config);
        this.sessions.put(sessionName, session);
        return true;
    }

    public boolean destroySession(String sessionName) {
        if (!this.sessions.containsKey(sessionName)) {
            return false;
        }
        this.endGame(sessionName);
        WorldGroup group = this.worldData.getWorldGroup(sessionName);
        if (group == null) {
            ConsoleMessenger.bug("Could not destroy worlds from session properly", (Object)this);
            return false;
        }
        this.worldData.destroyWorldGroup(group);
        this.sessions.get(sessionName).destroy();
        this.sessions.remove(sessionName);
        return true;
    }

    public boolean startGame(String sessionName) {
        if (!this.sessions.containsKey(sessionName)) {
            ConsoleMessenger.log("Cannot start a game that doesn't exist, create it first using '/autobingo <world> create'!");
            return false;
        }
        if (this.isSessionRunning(sessionName)) {
            ConsoleMessenger.log("Could not start bingo because the game is already running on world '" + sessionName + "'!");
            return false;
        }
        this.sessions.get(sessionName).startGame();
        return true;
    }

    public boolean endGame(String sessionName) {
        if (!this.isSessionRunning(sessionName)) {
            ConsoleMessenger.log("Could not end bingo because no game was started on world '" + sessionName + "'!");
            return false;
        }
        BingoSession session = this.sessions.get(sessionName);
        session.endGame();
        return true;
    }

    public BingoSession getSession(String sessionName) {
        if (this.sessions.containsKey(sessionName)) {
            return this.sessions.get(sessionName);
        }
        return null;
    }

    @Nullable
    public BingoSession getSessionFromWorld(@NotNull WorldHandle world) {
        for (String session : this.sessions.keySet()) {
            BingoSession s = this.sessions.get(session);
            if (!s.ownsWorld(world)) continue;
            return s;
        }
        return null;
    }

    public String getNameOfSession(@Nullable BingoSession session) {
        if (session == null) {
            return "";
        }
        return this.getSessionNames().stream().filter(name -> this.getSession((String)name) != null).findFirst().orElse("");
    }

    public void onPluginDisable() {
        for (String session : this.sessions.keySet()) {
            this.sessions.get(session).destroy();
            this.sessions.remove(session);
        }
    }

    public BingoConfigurationData getGameConfig() {
        return this.config;
    }

    public boolean isSessionRunning(String sessionName) {
        return this.sessions.containsKey(sessionName) && this.sessions.get(sessionName).isRunning();
    }

    public boolean canPlayerOpenMenus(PlayerHandle player) {
        return this.getSessionFromWorld(player.world()) != null;
    }

    public boolean teleportPlayerToSession(PlayerHandle player, String sessionName) {
        WorldGroup bingoWorld = this.worldData.getWorldGroup(sessionName);
        if (bingoWorld == null) {
            return false;
        }
        bingoWorld.teleportPlayer(player);
        return true;
    }

    @Nullable
    public BingoSession getSessionOfPlayer(PlayerHandle player) {
        for (String sessionName : this.sessions.keySet()) {
            BingoSession session = this.sessions.get(sessionName);
            BingoParticipant participant = session.teamManager.getPlayerAsParticipant(player);
            if (participant == null) continue;
            return session;
        }
        return null;
    }

    public Collection<String> getSessionNames() {
        return this.sessions.keySet();
    }

    public EventResult<?> handlePlayerTeleport(PlayerHandle player, WorldPosition fromPos, WorldPosition toPos) {
        WorldHandle targetWorld;
        WorldHandle sourceWorld = fromPos.world();
        if (sourceWorld == (targetWorld = toPos.world())) {
            return EventResult.PASS;
        }
        DebugLogger.addLog("Teleporting player already, returning early? " + this.teleportingPlayer);
        if (this.teleportingPlayer) {
            this.teleportingPlayer = false;
            return EventResult.PASS;
        }
        if (sourceWorld == null) {
            ConsoleMessenger.bug("Source world is invalid", (Object)this);
            return EventResult.PASS;
        }
        if (targetWorld == null) {
            ConsoleMessenger.bug("Target world is invalid", (Object)this);
            return EventResult.PASS;
        }
        DebugLogger.addLog("Source world: " + sourceWorld.name());
        DebugLogger.addLog("Target world: " + targetWorld.name());
        BingoSession sourceSession = this.getSessionFromWorld(sourceWorld);
        BingoSession targetSession = this.getSessionFromWorld(targetWorld);
        DebugLogger.addLog("Source session: " + (sourceSession != null ? this.getNameOfSession(sourceSession) : "<NULL>"));
        DebugLogger.addLog("Target session: " + (targetSession != null ? this.getNameOfSession(targetSession) : "<NULL>"));
        if (sourceSession == targetSession) {
            DebugLogger.addLog("Teleported using a portal, target session is the source session.");
            return EventResult.PASS;
        }
        boolean savePlayerInformation = this.config.getOptionValue(BingoOptions.SAVE_PLAYER_INFORMATION);
        boolean cancel = false;
        if (sourceSession != null) {
            if (targetSession == null) {
                DebugLogger.addLog("Player leaving the bingo world");
                player.clearInventory();
                if (savePlayerInformation) {
                    this.teleportingPlayer = true;
                    DebugLogger.addLog("Scheduling player load...");
                    this.runtime.getServerSoftware().runTask(t -> {
                        if (this.playerData.loadPlayer(player) == null) {
                            // empty if block
                        }
                        DebugLogger.addLog("Player loaded?");
                    });
                    cancel = true;
                }
            }
            sourceSession.removePlayer(player);
        }
        if (targetSession != null) {
            BingoSession previousSession;
            if (savePlayerInformation && sourceSession == null) {
                DebugLogger.addLog("Saving player data as they are entering a session world");
                SerializablePlayer serializablePlayer = SerializablePlayer.fromPlayer(this.runtime.getServerSoftware(), player);
                this.playerData.savePlayer(serializablePlayer, false);
            }
            if ((previousSession = this.getSessionOfPlayer(player)) != null) {
                BingoParticipant participant = previousSession.teamManager.getPlayerAsParticipant(player);
                if (participant != null) {
                    previousSession.removeParticipant(participant);
                } else {
                    BingoPlayer playerProxy = new BingoPlayer(player, previousSession);
                    previousSession.removeParticipant(playerProxy);
                }
                DebugLogger.addLog("Player teleported from one session to a different one(must be source session?) !");
            }
            player.setRespawnPoint(targetSession.getOverworld().spawnPoint(), true);
            targetSession.addPlayer(player);
        }
        return new EventResult<Object>(cancel, null);
    }

    public EventResult<?> handlePlayerJoinsServer(PlayerHandle player) {
        BingoSession targetSession = this.getSessionFromWorld(player.world());
        if (targetSession != null) {
            targetSession.addPlayer(player);
        }
        return EventResult.PASS;
    }

    public EventResult<?> handlePlayerQuitsServer(PlayerHandle player) {
        BingoSession sourceSession = this.getSessionFromWorld(player.world());
        if (sourceSession != null) {
            sourceSession.removePlayer(player);
        }
        this.runtime.getClientManager().playerLeavesServer(player);
        return EventResult.PASS;
    }

    public void prepareNextBingoGame(BingoSession session) {
        if (this.config.getOptionValue(BingoOptions.SAVE_PLAYER_INFORMATION).booleanValue() && this.config.getOptionValue(BingoOptions.LOAD_PLAYER_INFORMATION_STRATEGY) == BingoOptions.LoadPlayerInformationStrategy.AFTER_GAME) {
            for (BingoParticipant participant : session.teamManager.getParticipants()) {
                participant.sessionPlayer().ifPresent(player -> {
                    session.teamManager.removeMemberFromTeam(participant);
                    this.playerData.loadPlayer((PlayerHandle)player);
                });
            }
        }
    }

    public PlayerSerializationData getPlayerData() {
        return this.playerData;
    }

    public ServerSoftware getPlatform() {
        return this.runtime.getServerSoftware();
    }

    public BingoReloadedRuntime getRuntime() {
        return this.runtime;
    }

    public BingoEventListener eventListener() {
        return this.eventListener;
    }

    public BingoLobbyData getLobbyData() {
        return this.lobbyData;
    }
}

