/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop;

import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.data.world.WorldGroup;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SingularGameManager
extends GameManager {
    public SingularGameManager(@NotNull BingoReloadedRuntime runtime, BingoConfigurationData config) {
        super(runtime, config);
        WorldGroup group = this.createWorldGroupFromExistingWorlds();
        if (group == null) {
            return;
        }
        BingoSession session = new BingoSession(this, group, config);
        this.sessions.put(config.getOptionValue(BingoOptions.DEFAULT_WORLD_NAME), session);
    }

    @Override
    public void setup(List<String> worldNames) {
    }

    @Override
    public boolean destroySession(String sessionName) {
        ConsoleMessenger.error("Cannot destroy session when using configuration singular!");
        return false;
    }

    @Override
    public boolean createSession(String sessionName) {
        ConsoleMessenger.error("Cannot create session when using configuration singular!");
        return false;
    }

    private WorldGroup createWorldGroupFromExistingWorlds() {
        String defaultWorldName = this.getGameConfig().getOptionValue(BingoOptions.DEFAULT_WORLD_NAME);
        WorldHandle overworld = this.getPlatform().getWorld(defaultWorldName);
        WorldHandle nether = this.getPlatform().getWorld(defaultWorldName + "_nether");
        WorldHandle theEnd = this.getPlatform().getWorld(defaultWorldName + "_the_end");
        if (overworld == null) {
            ConsoleMessenger.error("Could not create world group from existing world; " + defaultWorldName + " does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        if (nether == null) {
            ConsoleMessenger.error("Could not create world group from existing world; " + defaultWorldName + "_nether does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        if (theEnd == null) {
            ConsoleMessenger.error("Could not create world group from existing world; " + defaultWorldName + "_the_end does not exist. Make sure the world exists and reload the plugin.");
            return null;
        }
        return new WorldGroup(this.getPlatform(), defaultWorldName, overworld.uniqueId(), nether.uniqueId(), theEnd.uniqueId());
    }
}

