/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop.phase;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.BingoEvents;
import io.github.steaf23.bingoreloaded.cards.CardFactory;
import io.github.steaf23.bingoreloaded.cards.LockoutTaskCard;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoSound;
import io.github.steaf23.bingoreloaded.data.BingoStatType;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.lib.api.BiomeType;
import io.github.steaf23.bingoreloaded.lib.api.InteractAction;
import io.github.steaf23.bingoreloaded.lib.api.PlayerGamemode;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.event.EventResults;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.world.BlockHelper;
import io.github.steaf23.bingoreloaded.menu.BingoGameInfoMenu;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.player.PlayerRespawnManager;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import io.github.steaf23.bingoreloaded.tasks.tracker.TaskProgressTracker;
import io.github.steaf23.bingoreloaded.util.ActionBarManager;
import io.github.steaf23.bingoreloaded.util.BingoPlayerSender;
import io.github.steaf23.bingoreloaded.util.timer.CountdownTimer;
import io.github.steaf23.bingoreloaded.util.timer.CounterTimer;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoGame
implements GamePhase {
    private final ServerSoftware platform;
    private final BingoSession session;
    private final BingoSettings settings;
    private final BingoGameInfoMenu scoreboard;
    private final TeamManager teamManager;
    private final PlayerRespawnManager respawnManager;
    private final TaskProgressTracker progressTracker;
    private final BingoConfigurationData config;
    private GameTimer timer;
    private CountdownTimer startingTimer;
    private boolean gameStarted;
    private final ActionBarManager actionBarManager;
    private final Map<UUID, WorldPosition> playerSpawnPoints;
    private GameTask deathMatchTask;
    private final Runnable onGameEndedCallback;
    @Nullable
    private final WorldPosition startPosition;

    public BingoGame(ServerSoftware platform, @NotNull BingoSession session, @NotNull BingoSettings settings, @NotNull BingoConfigurationData config, Runnable onGameEndedCallback, @Nullable WorldPosition atPosition) {
        this.platform = platform;
        this.session = session;
        this.config = config;
        this.teamManager = session.teamManager;
        this.scoreboard = session.gameInfoMenu;
        this.settings = settings;
        this.actionBarManager = new ActionBarManager(session);
        this.progressTracker = new TaskProgressTracker(platform, this);
        this.onGameEndedCallback = onGameEndedCallback;
        this.respawnManager = new PlayerRespawnManager(platform, config.getOptionValue(BingoOptions.TELEPORT_AFTER_DEATH_PERIOD));
        this.playerSpawnPoints = new HashMap<UUID, WorldPosition>();
        this.startPosition = atPosition;
    }

    private void start() {
        this.gameStarted = false;
        this.timer = this.settings.useCountdown() ? new CountdownTimer(this.settings.countdownDuration() * 60, 300, 60, this::onCountdownTimerFinished) : new CounterTimer();
        this.timer.addNotifier(time -> {
            Component timerMessage = this.timer.getTimeDisplayMessage(false);
            this.actionBarManager.requestMessage(p -> timerMessage, 0);
            this.actionBarManager.update();
            this.getProgressTracker().updateStatisticProgress();
        });
        this.deathMatchTask = null;
        WorldHandle world = this.session.getOverworld();
        if (world == null) {
            this.session.endGame();
            return;
        }
        String commandBeforeGame = this.config.getOptionValue(BingoOptions.SEND_COMMAND_BEFORE_GAME_STARTS);
        if (!commandBeforeGame.isEmpty()) {
            this.platform.sendConsoleCommand(commandBeforeGame);
        }
        world.setStorming(false);
        world.setTimeOfDay(1000L);
        boolean useAdvancements = !this.platform.areAdvancementsDisabled() && this.config.getOptionValue(BingoOptions.DISABLE_ADVANCEMENTS) == false;
        Set<TaskCard> uniqueCards = CardFactory.generateCardsForGame(this, useAdvancements, this.config.getOptionValue(BingoOptions.DISABLE_STATISTICS) == false);
        BingoMessage.GIVE_CARDS.sendToAudience((Audience)this.session, new Component[0]);
        this.teleportPlayersToStart(world);
        Object hoverMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(BingoMessage.OPTIONS_GAMEMODE.asPhrase(new Component[0]))).append((Component)Component.text(": "))).append(this.settings.mode().asComponent())).append((Component)Component.text(" "))).append(this.settings.size().asComponent())).append((Component)Component.text("\n"))).append(BingoMessage.OPTIONS_KIT.asPhrase(new Component[0]))).append((Component)Component.text(": "))).append(this.settings.kit().getDisplayName())).append((Component)Component.text("\n"))).append(BingoMessage.OPTIONS_EFFECTS.asPhrase(new Component[0]))).append((Component)Component.text(": \n"))).append(Component.join(JoinConfiguration.separator(Component.text("\n")), (ComponentLike[])EffectOptionFlags.effectsToText(this.settings.effects())))).append((Component)Component.text("\n"))).append(BingoMessage.DURATION.asPhrase(this.settings.useCountdown() ? GameTimer.getTimeAsComponent((long)this.settings.countdownDuration() * 60L) : Component.text("\u221e")))).build();
        BingoPlayerSender.sendMessage(BingoMessage.createHoverableMessage(Component.empty(), BingoMessage.SETTINGS_HOVER.asPhrase(new Component[0]), HoverEvent.showText((Component)hoverMessage), Component.empty()), (Audience)this.session);
        this.getTeamManager().getParticipants().forEach(p -> {
            if (p.sessionPlayer().isPresent()) {
                PlayerHandle player = p.sessionPlayer().get();
                p.giveKit(this.settings.kit());
                this.returnCardToPlayer(this.settings.kit().getCardSlot(), (BingoParticipant)p);
                player.setLevel(0);
                player.setExp(0.0f);
                this.getSession().getGameManager().getRuntime().gameDisplay().addPlayer(player);
                this.getSession().getGameManager().getRuntime().getClientManager().updateCard(player, p.getCard().orElse(null));
            } else if (!p.alwaysActive()) {
                this.session.removeParticipant((BingoParticipant)p);
            }
        });
        this.getProgressTracker().setUpdateClient(false);
        for (TaskCard card : uniqueCards) {
            card.getTasks().forEach(t -> this.getProgressTracker().startTrackingTask((GameTask)t));
        }
        this.getProgressTracker().setUpdateClient(true);
        this.scoreboard.setup(this.settings);
        this.session.getGameManager().getRuntime().gameDisplay().update(this.scoreboard);
        this.startingTimer = new CountdownTimer(Math.max(1, this.config.getOptionValue(BingoOptions.STARTING_COUNTDOWN_TIME)), 6, 3, this::onStartingTimerFinished);
        this.startingTimer.addNotifier(time -> {
            float pitch;
            Component timeComponent = Component.text(time);
            if (time == 0L) {
                timeComponent = ((TextComponent)Component.text("GO").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD);
                BingoPlayerSender.sendTitle(timeComponent, this.session);
            }
            NamedTextColor color = NamedTextColor.WHITE;
            if (time <= (long)this.startingTimer.lowThreshold) {
                pitch = 1.414214f;
                color = NamedTextColor.RED;
            } else if (time <= (long)this.startingTimer.medThreshold) {
                pitch = 1.059463f;
                color = NamedTextColor.GOLD;
            } else {
                pitch = 0.890899f;
            }
            BingoPlayerSender.sendTitle(timeComponent.color(color), this.session);
            if (time <= (long)this.startingTimer.lowThreshold && time > 0L) {
                this.playSound((Sound)BingoSound.COUNTDOWN_TICK_1.builder().volume(1.2f - (float)time.longValue() / 10.0f + 0.2f).pitch(pitch).build());
                this.playSound((Sound)BingoSound.COUNTDOWN_TICK_2.builder().volume(1.2f - (float)time.longValue() / 10.0f + 0.2f).pitch(pitch).build());
            }
        });
        this.platform.runTask(20L, task -> this.startingTimer.start());
    }

    public boolean hasStarted() {
        return this.gameStarted;
    }

    public void end(@Nullable BingoTeam winningTeam) {
        if (this.startingTimer != null) {
            this.startingTimer.stop();
        } else {
            ConsoleMessenger.bug("Could not stop the starting timer. This means something bad happened when ending a game, reload the plugin to continue without problems", (Object)this);
        }
        BingoPlayerSender.sendMessage(this.timer.getTimeDisplayMessage(false), (Audience)this.session);
        this.timer.stop();
        if (!this.config.getOptionValue(BingoOptions.KEEP_SCOREBOARD_VISIBLE).booleanValue()) {
            this.scoreboard.setup(this.settings);
            this.session.getGameManager().getRuntime().gameDisplay().update(this.scoreboard);
        }
        this.getTeamManager().getParticipants().forEach(p -> {
            p.takeEffects(false);
            p.sessionPlayer().ifPresent(player -> {
                int tasksCompleted = p.getAmountOfTaskCompleted();
                if (tasksCompleted > BingoReloaded.getPlayerStat(player, BingoStatType.RECORD_TASKS)) {
                    BingoReloaded.setPlayerStat(player, BingoStatType.RECORD_TASKS, tasksCompleted);
                }
            });
        });
        this.playSound((Sound)BingoSound.GAME_ENDED.builder().build());
        String command = this.config.getOptionValue(BingoOptions.SEND_COMMAND_AFTER_GAME_ENDS);
        if (!command.isEmpty()) {
            this.platform.sendConsoleCommand(command);
        }
        this.session.sendMessage(Component.text(" "));
        this.onGameEndedCallback.run();
    }

    public void bingo(@NotNull BingoTeam team) {
        BingoMessage.BINGO.sendToAudience((Audience)this.session, team.getColoredName());
        for (BingoParticipant p : this.getTeamManager().getParticipants()) {
            if (p.sessionPlayer().isEmpty()) continue;
            PlayerHandle player = p.sessionPlayer().get();
            if (team.equals(p.getTeam())) {
                BingoReloaded.incrementPlayerStat(player, BingoStatType.WINS);
                continue;
            }
            BingoReloaded.incrementPlayerStat(player, BingoStatType.LOSSES);
        }
        this.playSound((Sound)BingoSound.GAME_WON.builder().build());
        this.end(team);
    }

    public long getGameTime() {
        if (this.timer != null) {
            return this.timer.getTime();
        }
        return 0L;
    }

    public BingoSettings getSettings() {
        return this.settings;
    }

    public BingoConfigurationData getConfig() {
        return this.config;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public GameTimer getTimer() {
        return this.timer;
    }

    public ActionBarManager getActionBar() {
        return this.actionBarManager;
    }

    public void returnCardToPlayer(int cardSlot, BingoParticipant participant) {
        if (participant.sessionPlayer().isEmpty()) {
            return;
        }
        StackHandle cardItem = this.getSession().getGameManager().getRuntime().createCardItemForPlayer(participant);
        participant.giveBingoCard(cardSlot, cardItem);
        participant.sessionPlayer().get().setGamemode(PlayerGamemode.SURVIVAL);
        this.platform.runTask(task -> participant.giveEffects(this.settings.effects(), this.config.getOptionValue(BingoOptions.GRACE_PERIOD)));
    }

    public void startDeathMatch(int seconds) {
        BingoMessage.DEATHMATCH_START.sendToAudience((Audience)this.session, new Component[0]);
        this.playSound((Sound)BingoSound.DEATHMATCH_INITIATED.builder().build());
        this.startDeathMatchRecurse(seconds);
    }

    private void startDeathMatchRecurse(int countdown) {
        if (countdown == 0) {
            this.deathMatchTask = new GameTask(new BingoCardData().getRandomItemTask(this.settings.card()));
            BingoPlayerSender.sendTitle(((TextComponent)Component.text("GO").color(NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), BingoMessage.DEATHMATCH_SEARCH.asPhrase(new Component[0]).color(NamedTextColor.DARK_PURPLE).decorate(TextDecoration.ITALIC), this.session);
            TaskData taskData = this.deathMatchTask.data;
            if (!(taskData instanceof ItemTask)) {
                ConsoleMessenger.bug("Cannot play deathmatch with a non-item task!", (Object)this);
                this.end();
                return;
            }
            ItemTask itemTask = (ItemTask)taskData;
            for (BingoParticipant p : this.getTeamManager().getParticipants()) {
                if (p.sessionPlayer().isEmpty()) continue;
                p.showDeathMatchTask(itemTask);
            }
            this.playSound((Sound)BingoSound.DEATHMATCH_REVEAL.builder().build());
            return;
        }
        TextComponent countdownComponent = Component.text(countdown);
        NamedTextColor color = switch (countdown) {
            case 1 -> NamedTextColor.RED;
            case 2 -> NamedTextColor.GOLD;
            default -> NamedTextColor.GREEN;
        };
        BingoPlayerSender.sendTitle(countdownComponent.color(color), this.session);
        BingoPlayerSender.sendMessage(countdownComponent.color(color), (Audience)this.session);
        this.platform.runTask(20L, task -> this.startDeathMatchRecurse(countdown - 1));
    }

    public void teleportPlayerAfterDeath(PlayerHandle player) {
        if (player == null) {
            return;
        }
        this.respawnManager.removeDeadPlayer(player.uniqueId()).ifPresentOrElse(player::teleportAsync, () -> BingoMessage.RESPAWN_EXPIRED.sendToAudience((Audience)player, (TextColor)NamedTextColor.RED, new Component[0]));
    }

    public static void spawnPlatform(WorldPosition platformLocation, int size, boolean clearArea) {
        BlockHelper.buildPlatform(ItemType.of("minecraft:white_stained_glass"), platformLocation, size, size, true, null);
        if (!clearArea) {
            return;
        }
        BlockHelper.buildCuboid(ItemType.AIR, platformLocation.clone(), size, size, 3, false, null);
    }

    public static void removePlatform(WorldPosition platformLocation, int size) {
        BlockHelper.buildPlatform(ItemType.AIR, platformLocation, size, size, true, ItemType.of("minecraft:white_stained_glass"));
    }

    private void teleportPlayersToStart(WorldHandle world) {
        int gracePeriod = this.config.getOptionValue(BingoOptions.GRACE_PERIOD);
        int platformLifetime = Math.max(this.config.getOptionValue(BingoOptions.STARTING_COUNTDOWN_TIME), Math.max(0, gracePeriod - 5)) * 20;
        if (this.startPosition != null) {
            WorldPosition spawnLocation = this.startPosition.clone().setY(BlockHelper.getHighestBlockYAtPos(this.startPosition));
            if (!this.getTeamManager().getParticipants().isEmpty()) {
                BingoGame.spawnPlatform(spawnLocation, 5, true);
                this.platform.runTask(platformLifetime, task -> BingoGame.removePlatform(spawnLocation, 5));
            }
            Set<BingoParticipant> players = this.getTeamManager().getParticipants();
            players.forEach(p -> this.teleportPlayerToStart((BingoParticipant)p, spawnLocation, 5));
            return;
        }
        switch (this.config.getOptionValue(BingoOptions.PLAYER_TELEPORT_STRATEGY)) {
            case ALONE: {
                for (BingoParticipant p2 : this.getTeamManager().getParticipants()) {
                    WorldPosition platformLocation = this.getRandomSpawnLocation(world);
                    if (!this.getTeamManager().getParticipants().isEmpty()) {
                        BingoGame.spawnPlatform(platformLocation.clone(), 5, true);
                        this.platform.runTask(platformLifetime, task -> BingoGame.removePlatform(platformLocation, 5));
                    }
                    this.teleportPlayerToStart(p2, platformLocation, 5);
                }
                break;
            }
            case TEAM: {
                for (BingoTeam t : this.getTeamManager().getActiveTeams()) {
                    WorldPosition teamLocation = this.getRandomSpawnLocation(world);
                    Set<BingoParticipant> players = t.getMembers();
                    if (!players.isEmpty()) {
                        BingoGame.spawnPlatform(teamLocation, 5, true);
                        this.platform.runTask(platformLifetime, task -> BingoGame.removePlatform(teamLocation, 5));
                    }
                    players.forEach(p -> this.teleportPlayerToStart((BingoParticipant)p, teamLocation, 5));
                }
                break;
            }
            case ALL: {
                WorldPosition spawnLocation = this.getRandomSpawnLocation(world);
                if (!this.getTeamManager().getParticipants().isEmpty()) {
                    BingoGame.spawnPlatform(spawnLocation, 5, true);
                    this.platform.runTask(platformLifetime, task -> BingoGame.removePlatform(spawnLocation, 5));
                }
                Set<BingoParticipant> players = this.getTeamManager().getParticipants();
                players.forEach(p -> this.teleportPlayerToStart((BingoParticipant)p, spawnLocation, 5));
                break;
            }
        }
    }

    private void teleportPlayerToStart(BingoParticipant participant, WorldPosition to, int spread) {
        if (participant.sessionPlayer().isEmpty()) {
            return;
        }
        PlayerHandle player = participant.sessionPlayer().get();
        WorldPosition playerLocation = BlockHelper.getRandomPosWithinRange(to, spread, spread);
        playerLocation.moveYBlocks(5);
        player.teleportAsync(playerLocation);
        WorldPosition spawnLocation = to.clone().moveYBlocks(2);
        player.setRespawnPoint(spawnLocation, true);
        this.playerSpawnPoints.put(player.uniqueId(), spawnLocation);
    }

    private WorldPosition getRandomSpawnLocation(WorldHandle world) {
        int teleportMaxDistance = this.config.getOptionValue(BingoOptions.TELEPORT_MAX_DISTANCE);
        WorldPosition randomPosition = BlockHelper.getRandomPosWithinRange(new WorldPosition(world, 0.0, 0.0, 0.0), teleportMaxDistance, teleportMaxDistance);
        WorldPosition location = new WorldPosition(world, randomPosition.x(), (double)BlockHelper.getHighestBlockYAtPos(randomPosition), randomPosition.z());
        while (BingoGame.isOceanBiome(world.biomeAtPos(location))) {
            randomPosition = BlockHelper.getRandomPosWithinRange(new WorldPosition(world, 0.0, 0.0, 0.0), teleportMaxDistance, teleportMaxDistance);
            location = new WorldPosition(world, randomPosition.x(), (double)BlockHelper.getHighestBlockYAtPos(randomPosition), randomPosition.z());
        }
        return location;
    }

    public static boolean isOceanBiome(BiomeType biome) {
        return biome.isOcean() || biome.isRiver();
    }

    public GameTask getDeathMatchTask() {
        return this.deathMatchTask;
    }

    public TaskProgressTracker getProgressTracker() {
        return this.progressTracker;
    }

    public void playSound(Sound sound) {
        this.session.playSound(sound);
    }

    public void onBingoTaskCompleted(@NotNull BingoParticipant participant, GameTask task) {
        Component timeString = GameTimer.getTimeAsComponent(this.getGameTime());
        BingoTeam team = task.getCompletedByTeam().orElse(null);
        if (team == null) {
            ConsoleMessenger.bug("Player " + participant.getName() + " is not in a team?", (Object)this);
            return;
        }
        BingoMessage.COMPLETED.sendToAudience((Audience)this.session, (TextColor)NamedTextColor.AQUA, task.data.getName(), participant.getDisplayName().color(team.getColor()).decorate(TextDecoration.BOLD), timeString.color(NamedTextColor.WHITE));
        this.playSound((Sound)BingoSound.TASK_COMPLETED.builder().build());
        this.scoreboard.updateTeamScores();
        this.session.getGameManager().getRuntime().gameDisplay().update(this.scoreboard);
        this.teamManager.getParticipants().forEach(a -> {
            if (a.sessionPlayer().isEmpty()) {
                return;
            }
            this.session.getGameManager().getRuntime().getClientManager().updateCard(a.sessionPlayer().get(), a.getCard().orElse(null));
        });
        participant.sessionPlayer().ifPresent(player -> BingoReloaded.incrementPlayerStat(player, BingoStatType.TASKS));
        if (participant.getCard().isPresent() && participant.getCard().get().hasTeamWon(team)) {
            this.bingo(team);
            return;
        }
        BingoTeam leadingTeam = this.teamManager.getActiveTeams().getLeadingTeam();
        if (leadingTeam == null) {
            return;
        }
        Optional<TaskCard> card = this.teamManager.getActiveTeams().getLeadingTeam().getCard();
        Object var8_7 = card.orElse(null);
        if (!(var8_7 instanceof LockoutTaskCard)) {
            return;
        }
        LockoutTaskCard lockoutCard = var8_7;
        if (this.teamManager.getActiveTeams().getTotalCompleteCount() == lockoutCard.size.fullCardSize) {
            this.startDeathMatch(5);
        }
    }

    public void onDeathmatchTaskComplete(BingoParticipant participant, GameTask deathMatchTask) {
        BingoTeam team = deathMatchTask.getCompletedByTeam().orElse(null);
        if (participant == null) {
            ConsoleMessenger.bug("Task not completed correctly...?", (Object)this);
            return;
        }
        if (team == null) {
            ConsoleMessenger.bug("Player " + participant.getName() + " completing Deathmatch task is not in a team?", (Object)this);
            return;
        }
        this.bingo(team);
    }

    public EventResult<?> handlePlayerFallDamage(PlayerHandle player) {
        BingoParticipant participant = this.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return EventResult.PASS;
        }
        if (!this.getTeamManager().getParticipants().contains(participant)) {
            return EventResult.PASS;
        }
        if (this.settings.effects().contains((Object)EffectOptionFlags.NO_FALL_DAMAGE)) {
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    public EventResult<EventResults.PlayerDeathResult> handlePlayerDeath(PlayerHandle player, Collection<? extends StackHandle> droppedItems) {
        BingoParticipant participant = this.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return new EventResult<Object>(false, null);
        }
        boolean keepInventory = false;
        if (this.settings.effects().contains((Object)EffectOptionFlags.KEEP_INVENTORY)) {
            keepInventory = true;
        } else {
            for (StackHandle stackHandle : droppedItems) {
                TagDataStorage data = stackHandle.getStorage();
                if (!data.getBoolean("kit_item", false) && !PlayerKit.CARD_ITEM.isCompareKeyEqual(stackHandle)) continue;
                stackHandle.setAmount(0);
            }
        }
        WorldPosition deathCoords = player.position();
        if (this.config.getOptionValue(BingoOptions.TELEPORT_AFTER_DEATH).booleanValue()) {
            Arrays.stream(BingoMessage.RESPAWN.convertForPlayer(player, new Component[0])).reduce(Component::append).ifPresent(hoverable -> {
                BingoPlayerSender.sendMessage(BingoMessage.createHoverCommandMessage(Component.empty(), hoverable, null, Component.empty(), "/bingo back"), (Audience)player);
                this.respawnManager.addPlayer(player.uniqueId(), deathCoords);
            });
        }
        return EventResults.playerDeathResult(false, keepInventory);
    }

    public EventResult<EventResults.PlayerRespawnResult> handlePlayerRespawn(PlayerHandle player, boolean isBedSpawn, boolean isAnchorSpawn) {
        boolean correctRespawnPoint;
        BingoParticipant participant = this.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return EventResults.playerRespawnResult(false, false, null);
        }
        if (!(participant instanceof BingoPlayer)) {
            return EventResults.playerRespawnResult(false, false, null);
        }
        BingoPlayer bingoPlayer = (BingoPlayer)participant;
        if (!this.settings.effects().contains((Object)EffectOptionFlags.KEEP_INVENTORY)) {
            this.returnCardToPlayer(this.settings.kit().getCardSlot(), bingoPlayer);
            bingoPlayer.giveKit(this.settings.kit());
        } else {
            bingoPlayer.giveEffects(this.settings.effects(), 0);
        }
        boolean bl = correctRespawnPoint = !isBedSpawn && !isAnchorSpawn && player.respawnPoint() == null;
        if (correctRespawnPoint && this.playerSpawnPoints.containsKey(bingoPlayer.getId())) {
            WorldPosition newSpawnLocation = this.playerSpawnPoints.get(bingoPlayer.getId());
            player.setRespawnPoint(newSpawnLocation, true);
            return EventResults.playerRespawnResult(false, true, newSpawnLocation);
        }
        return EventResults.playerRespawnResult(false, false, null);
    }

    public void onStartingTimerFinished() {
        this.timer.start();
        this.gameStarted = true;
        this.playSound((Sound)BingoSound.START_COUNTDOWN_FINISHED_1.builder().build());
        this.playSound((Sound)BingoSound.START_COUNTDOWN_FINISHED_2.builder().build());
    }

    public void onCountdownTimerFinished() {
        BingoTeam leadingTeam = this.getTeamManager().getActiveTeams().getLeadingTeam();
        HashSet<BingoTeam> tiedTeams = new HashSet<BingoTeam>();
        tiedTeams.add(leadingTeam);
        if (this.settings.mode() == BingoGamemode.REGULAR || leadingTeam == null) {
            this.end(null);
            return;
        }
        int leadingPoints = leadingTeam.getCompleteCount();
        for (BingoTeam team : this.getTeamManager().getActiveTeams()) {
            if (team.getCompleteCount() == leadingPoints) {
                tiedTeams.add(team);
                continue;
            }
            team.outOfTheGame = true;
        }
        if (tiedTeams.size() == 1) {
            this.bingo(leadingTeam);
        } else {
            this.startDeathMatch(5);
        }
    }

    public EventResult<?> handlePlayerMove(PlayerHandle player, WorldPosition from, WorldPosition to) {
        if (this.gameStarted) {
            return EventResult.PASS;
        }
        BingoParticipant participant = this.teamManager.getPlayerAsParticipant(player);
        if (participant == null) {
            return EventResult.PASS;
        }
        return EventResult.CANCEL;
    }

    public EventResult<?> handlePlayerStackDamaged(PlayerHandle player, StackHandle item) {
        if (this.settings.effects().contains((Object)EffectOptionFlags.NO_DURABILITY) && (item.isTool() || item.isArmor())) {
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    @Override
    public void setup() {
        this.start();
    }

    @Override
    public void end() {
        this.end(null);
    }

    @Override
    public EventResult<?> handlePlayerInteracted(PlayerHandle player, @Nullable StackHandle stack, InteractAction action) {
        BingoParticipant participant = this.getTeamManager().getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return EventResult.PASS;
        }
        if (participant.sessionPlayer().get().gamemode() == PlayerGamemode.SPECTATOR) {
            return EventResult.PASS;
        }
        if (stack == null || stack.type().isAir()) {
            return EventResult.PASS;
        }
        if (!action.rightClick()) {
            return EventResult.PASS;
        }
        if (PlayerKit.WAND_ITEM.isCompareKeyEqual(stack)) {
            if (!this.gameStarted) {
                return EventResult.PASS;
            }
            ((BingoPlayer)participant).useGoUpWand(stack, this.config.getOptionValue(BingoOptions.GO_UP_WAND_COOLDOWN), this.config.getOptionValue(BingoOptions.GO_UP_WAND_DOWN_DISTANCE), this.config.getOptionValue(BingoOptions.GO_UP_WAND_UP_DISTANCE), this.config.getOptionValue(BingoOptions.GO_UP_WAND_PLATFORM_LIFETIME));
            return EventResult.CANCEL;
        }
        if (PlayerKit.CARD_ITEM.isCompareKeyEqual(stack)) {
            if (this.deathMatchTask == null) {
                participant.showCard(null);
            } else {
                TaskData taskData = this.deathMatchTask.data;
                if (!(taskData instanceof ItemTask)) {
                    return EventResult.CANCEL;
                }
                ItemTask itemTask = (ItemTask)taskData;
                participant.showCard(itemTask);
                return EventResult.CANCEL;
            }
        }
        return EventResult.PASS;
    }

    @Override
    @NotNull
    public BingoSession getSession() {
        return this.session;
    }

    @Override
    public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
        BingoParticipant participant = this.teamManager.getPlayerAsParticipant(player);
        if (!(participant instanceof BingoPlayer)) {
            return;
        }
        BingoPlayer bingoPlayer = (BingoPlayer)participant;
        bingoPlayer.giveEffects(this.settings.effects(), this.config.getOptionValue(BingoOptions.GRACE_PERIOD));
    }

    @Override
    public void handlePlayerLeftSessionWorld(PlayerHandle player) {
        BingoParticipant participant = this.teamManager.getPlayerAsParticipant(player);
        if (!(participant instanceof BingoPlayer)) {
            return;
        }
        BingoPlayer bingoPlayer = (BingoPlayer)participant;
        bingoPlayer.takeEffects(false);
    }

    @Override
    public void handleSettingsUpdated(BingoSettings newSettings) {
    }

    @Override
    public void handleParticipantJoinedTeam(BingoEvents.TeamParticipantEvent event) {
        BingoParticipant bingoParticipant = event.participant();
        if (!(bingoParticipant instanceof BingoPlayer)) {
            return;
        }
        BingoPlayer player = (BingoPlayer)bingoParticipant;
        player.giveEffects(this.settings.effects(), this.config.getOptionValue(BingoOptions.GRACE_PERIOD));
    }

    @Override
    public void handleParticipantLeftTeam(BingoEvents.TeamParticipantEvent event) {
        BingoParticipant bingoParticipant = event.participant();
        if (!(bingoParticipant instanceof BingoPlayer)) {
            return;
        }
        BingoPlayer player = (BingoPlayer)bingoParticipant;
        player.takeEffects(false);
    }

    @Override
    public boolean canViewCard() {
        return this.gameStarted;
    }
}

