/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop.phase;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.lib.api.InteractAction;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.util.timer.CountdownTimer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;

public class PostGamePhase
implements GamePhase {
    private final CountdownTimer timer;
    private final BingoSession session;

    public PostGamePhase(BingoSession session, int durationSeconds) {
        this.session = session;
        this.timer = new CountdownTimer(durationSeconds, this::onTimerFinished);
    }

    @Override
    @Nullable
    public BingoSession getSession() {
        return this.session;
    }

    @Override
    public void setup() {
        if (this.timer.getStartTime() <= 0) {
            this.session.prepareNextGame();
            this.timer.stop();
            return;
        }
        this.timer.start();
        this.timer.addNotifier(this::onTimerTicks);
        this.sendRestartMessage(this.timer.getTime(), this.session);
    }

    @Override
    public void end() {
        for (PlayerHandle p : this.session.getPlayersInWorld()) {
            p.closeInventory();
        }
        for (BingoTeam team : this.session.teamManager.getActiveTeams()) {
            team.setCard(null);
        }
    }

    @Override
    public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
        this.sendRestartMessage(this.timer.getTime(), player);
    }

    @Override
    public void handlePlayerLeftSessionWorld(PlayerHandle player) {
    }

    @Override
    public void handleSettingsUpdated(BingoSettings newSettings) {
    }

    @Override
    public EventResult<?> handlePlayerInteracted(PlayerHandle player, @Nullable StackHandle stack, InteractAction action) {
        BingoParticipant participant = this.session.teamManager.getPlayerAsParticipant(player);
        if (participant == null || participant.sessionPlayer().isEmpty()) {
            return EventResult.PASS;
        }
        if (stack == null || stack.type().isAir()) {
            return EventResult.PASS;
        }
        if (!action.rightClick()) {
            return EventResult.PASS;
        }
        if (PlayerKit.CARD_ITEM.isCompareKeyEqual(stack)) {
            participant.showCard(null);
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    @Override
    public boolean canViewCard() {
        return true;
    }

    private void onTimerTicks(long timeLeft) {
        if (timeLeft == 5L) {
            this.sendRestartMessage(timeLeft, this.session);
        }
    }

    private void onTimerFinished() {
        this.session.prepareNextGame();
        this.timer.stop();
    }

    public void sendRestartMessage(long timeLeft, Audience audience) {
        BingoMessage.POST_GAME_START.sendToAudience(audience, (TextColor)NamedTextColor.RED, Component.text(timeLeft).color(NamedTextColor.BLUE));
    }
}

