/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop.phase;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.BingoEvents;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteTicket;
import io.github.steaf23.bingoreloaded.lib.api.BingoReloadedRuntime;
import io.github.steaf23.bingoreloaded.lib.api.InteractAction;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.menu.BingoSettingsInfoMenu;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.util.timer.CountdownTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PregameLobby
implements GamePhase {
    private final BingoSession session;
    private final Map<UUID, VoteTicket> votes;
    private final BingoConfigurationData config;
    private final CountdownTimer playerCountTimer;
    private final BingoReloadedRuntime runtime;
    private final BingoSettingsInfoMenu infoMenu;
    private boolean playerCountTimerPaused = false;
    private boolean gameStarted = false;

    public PregameLobby(BingoSession session, BingoConfigurationData config) {
        this.session = session;
        this.runtime = session.getGameManager().getRuntime();
        this.votes = new HashMap<UUID, VoteTicket>();
        this.config = config;
        this.playerCountTimer = new CountdownTimer(config.getOptionValue(BingoOptions.PLAYER_WAIT_TIME), this::onCountdownTimerFinished);
        this.infoMenu = new BingoSettingsInfoMenu();
        this.playerCountTimer.addNotifier(this::updateCounterVisual);
    }

    private void updateCounterVisual(long time) {
        this.infoMenu.setStatus(BingoMessage.STARTING_STATUS.asPhrase(Component.text(String.valueOf(time))));
        if (time == 10L) {
            BingoMessage.STARTING_STATUS.sendToAudience((Audience)this.session, Component.text(time).color(NamedTextColor.GOLD));
        } else if (time <= 5L) {
            BingoMessage.STARTING_STATUS.sendToAudience((Audience)this.session, Component.text(time).color(NamedTextColor.RED));
        }
    }

    private void onCountdownTimerFinished() {
        this.gameStarted = true;
        this.session.startGame();
    }

    public void voteGamemode(String gamemode, PlayerHandle player) {
        this.registerVote(VoteTicket.CATEGORY_GAMEMODE, gamemode, player);
    }

    public void voteCard(@NotNull String card, PlayerHandle player) {
        this.registerVote(VoteTicket.CATEGORY_CARD, card, player);
    }

    public void voteKit(String kit, PlayerHandle player) {
        this.registerVote(VoteTicket.CATEGORY_KIT, kit, player);
    }

    public void voteCardsize(String cardSize, PlayerHandle player) {
        this.registerVote(VoteTicket.CATEGORY_CARDSIZE, cardSize, player);
    }

    public void registerVote(VoteCategory<?> category, @NotNull String value, PlayerHandle player) {
        if (!this.config.getOptionValue(BingoOptions.USE_VOTE_SYSTEM).booleanValue()) {
            ConsoleMessenger.warn("Players cannot vote because useVoteSystem is set to false in config.yml!");
            return;
        }
        VoteTicket ticket = this.votes.getOrDefault(player.uniqueId(), new VoteTicket());
        if (value.equals(ticket.getVote(category))) {
            return;
        }
        if (!ticket.addVote(category, value)) {
            ConsoleMessenger.error("Player cannot vote for " + String.valueOf(category) + " " + value);
            return;
        }
        this.votes.put(player.uniqueId(), ticket);
        int count = 0;
        for (VoteTicket t : this.votes.values()) {
            if (!value.equals(t.getVote(category))) continue;
            ++count;
        }
        BingoMessage.VOTE_COUNT.sendToAudience((Audience)this.session, Component.text(count).color(NamedTextColor.GOLD), category.asComponent(), category.getValueComponent(value));
    }

    private void giveVoteItem(PlayerHandle player) {
        player.inventory().addItem(PlayerKit.VOTE_ITEM.buildItem());
    }

    private void giveTeamItem(PlayerHandle player) {
        player.inventory().addItem(PlayerKit.TEAM_ITEM.buildItem());
    }

    private void initializePlayer(PlayerHandle player) {
        this.runtime.settingsDisplay().addPlayer(player);
        player.clearInventory();
        if (this.config.getOptionValue(BingoOptions.USE_VOTE_SYSTEM).booleanValue() && !this.config.getOptionValue(BingoOptions.VOTE_USING_COMMANDS_ONLY).booleanValue() && !this.config.getOptionValue(BingoOptions.VOTE_LIST).isEmpty()) {
            this.giveVoteItem(player);
        }
        if (!this.config.getOptionValue(BingoOptions.SELECT_TEAMS_USING_COMMANDS_ONLY).booleanValue()) {
            this.giveTeamItem(player);
        }
    }

    public void pausePlayerCountTimer() {
        this.playerCountTimerPaused = true;
        this.playerCountTimer.stop();
        this.infoMenu.setStatus(BingoMessage.WAIT_STATUS.asPhrase(new Component[0]));
        this.runtime.settingsDisplay().update(this.infoMenu);
    }

    public void resumePlayerCountTimer() {
        this.playerCountTimerPaused = false;
        int playerCount = this.session.teamManager.getParticipantCount();
        if (playerCount == 0) {
            this.infoMenu.setStatus(BingoMessage.WAIT_STATUS.asPhrase(new Component[0]));
        } else {
            this.infoMenu.setStatus(BingoMessage.PLAYER_STATUS.asPhrase(Component.text(playerCount)));
        }
        this.runtime.settingsDisplay().update(this.infoMenu);
        this.startPlayerCountTimerIfMinCountReached();
    }

    public void playerCountTimerTogglePause() {
        if (this.playerCountTimerPaused) {
            this.resumePlayerCountTimer();
        } else {
            this.pausePlayerCountTimer();
        }
    }

    private void startPlayerCountTimerIfMinCountReached() {
        int minimumPlayerCount = this.config.getOptionValue(BingoOptions.MINIMUM_PLAYER_COUNT);
        if (minimumPlayerCount == 0 || this.gameStarted) {
            return;
        }
        if (this.session.teamManager.getParticipantCount() < minimumPlayerCount) {
            return;
        }
        if (this.playerCountTimer.isRunning() || this.playerCountTimerPaused) {
            return;
        }
        this.playerCountTimer.start();
        if (this.playerCountTimer.getTime() > 10L) {
            BingoMessage.STARTING_STATUS.sendToAudience((Audience)this.session, Component.text(this.config.getOptionValue(BingoOptions.PLAYER_WAIT_TIME)).color(NamedTextColor.GOLD));
        }
    }

    @Override
    @Nullable
    public BingoSession getSession() {
        return this.session;
    }

    @Override
    public void setup() {
        int playerCount = this.session.teamManager.getParticipantCount();
        this.infoMenu.updateSettings(this.session.settingsBuilder.view(), this.config);
        if (playerCount == 0) {
            this.infoMenu.setStatus(BingoMessage.WAIT_STATUS.asPhrase(new Component[0]));
        } else {
            this.infoMenu.setStatus(BingoMessage.PLAYER_STATUS.asPhrase(Component.text(playerCount)));
        }
        this.runtime.settingsDisplay().update(this.infoMenu);
        this.session.getGameManager().getPlatform().runTask(10L, t -> {
            if (this.gameStarted) {
                return;
            }
            this.session.getPlayersInWorld().stream().filter(this.session::hasPlayer).forEach(this::initializePlayer);
            this.startPlayerCountTimerIfMinCountReached();
        });
    }

    @Override
    public void end() {
        this.playerCountTimer.stop();
        this.runtime.settingsDisplay().clearPlayers();
    }

    @Override
    public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
        this.initializePlayer(player);
    }

    @Override
    public void handlePlayerLeftSessionWorld(PlayerHandle player) {
        this.runtime.settingsDisplay().removePlayer(player);
        this.session.teamManager.removeMemberFromTeam(this.session.teamManager.getPlayerAsParticipant(player));
    }

    @Override
    public void handleSettingsUpdated(BingoSettings newSettings) {
        this.infoMenu.updateSettings(newSettings, this.config);
        this.runtime.settingsDisplay().update(this.infoMenu);
    }

    @Override
    public EventResult<?> handlePlayerInteracted(PlayerHandle player, @Nullable StackHandle stack, InteractAction action) {
        if (stack == null || stack.type().isAir()) {
            return EventResult.PASS;
        }
        if (!action.rightClick()) {
            return EventResult.PASS;
        }
        if (PlayerKit.VOTE_ITEM.isCompareKeyEqual(stack)) {
            BingoReloaded.runtime().openVoteMenu(player, this);
            return EventResult.CANCEL;
        }
        if (PlayerKit.TEAM_ITEM.isCompareKeyEqual(stack)) {
            BingoReloaded.runtime().openTeamSelector(player, this.session);
            return EventResult.CANCEL;
        }
        return EventResult.PASS;
    }

    @Override
    public void handleParticipantJoinedTeam(BingoEvents.TeamParticipantEvent event) {
        this.infoMenu.setStatus(BingoMessage.PLAYER_STATUS.asPhrase(Component.text(this.session.teamManager.getParticipantCount())));
        this.runtime.settingsDisplay().update(this.infoMenu);
        if (this.playerCountTimer.isRunning() && this.playerCountTimer.getTime() > 10L) {
            event.participant().sessionPlayer().ifPresent(p -> BingoMessage.STARTING_STATUS.sendToAudience((Audience)p, Component.text(this.playerCountTimer.getTime()).color(NamedTextColor.GOLD)));
        }
        this.startPlayerCountTimerIfMinCountReached();
    }

    @Override
    public void handleParticipantLeftTeam(BingoEvents.TeamParticipantEvent event) {
        int playerCount = this.session.teamManager.getParticipantCount();
        if (playerCount == 0) {
            this.infoMenu.setStatus(BingoMessage.WAIT_STATUS.asPhrase(new Component[0]));
        } else {
            this.infoMenu.setStatus(BingoMessage.PLAYER_STATUS.asPhrase(Component.text("" + playerCount)));
        }
        this.runtime.settingsDisplay().update(this.infoMenu);
        this.session.getGameManager().getPlatform().runTask(t -> {
            if (this.session.teamManager.getParticipantCount() < this.config.getOptionValue(BingoOptions.MINIMUM_PLAYER_COUNT) && this.playerCountTimer.isRunning()) {
                this.playerCountTimer.stop();
            }
        });
    }

    @Override
    public boolean canViewCard() {
        return false;
    }

    public void handlePlayerRespawn(PlayerHandle player) {
        this.initializePlayer(player);
    }

    public Collection<VoteTicket> getAllVotes() {
        ArrayList<VoteTicket> result = new ArrayList<VoteTicket>();
        for (UUID playerId : this.votes.keySet()) {
            result.add(this.votes.get(playerId));
        }
        return result;
    }
}

