/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop.vote;

import io.github.steaf23.bingoreloaded.gameloop.vote.VoteTicket;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VoteCategory<Result>
implements ComponentLike {
    private final String configName;
    private final Component displayName;

    public VoteCategory(String configName, Component displayName) {
        this.configName = configName;
        this.displayName = displayName;
    }

    @NotNull
    abstract List<String> getValidValues();

    @Nullable
    abstract Result createResultForValue(String var1);

    public abstract Component getValueComponent(String var1);

    String getConfigName() {
        return this.configName;
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.displayName;
    }

    @Nullable
    public Result getValidResultOrNull(VoteTicket ticket) {
        Result result;
        String value = ticket.getVote(this);
        if (value == null) {
            return null;
        }
        if (this.getValidValues().contains(value) && (result = this.createResultForValue(value)) != null) {
            return result;
        }
        ConsoleMessenger.error("Invalid " + this.configName + " " + value + " found while collecting votes");
        return null;
    }

    public String toString() {
        return this.configName;
    }
}

