/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gameloop.vote;

import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.gameloop.vote.CardCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.CardSizeCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.GamemodeCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.KitCategory;
import io.github.steaf23.bingoreloaded.gameloop.vote.VoteCategory;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VoteTicket {
    public static final VoteCategory<BingoGamemode> CATEGORY_GAMEMODE = new GamemodeCategory();
    public static final VoteCategory<PlayerKit> CATEGORY_KIT = new KitCategory();
    public static final VoteCategory<String> CATEGORY_CARD = new CardCategory();
    public static final VoteCategory<CardSize> CATEGORY_CARDSIZE = new CardSizeCategory();
    private final Map<VoteCategory<?>, String> votes = new HashMap();

    public boolean isEmpty() {
        return this.votes.isEmpty();
    }

    public boolean addVote(VoteCategory<?> category, String value) {
        if (category.getValidValues().contains(value)) {
            this.votes.put(category, value);
            return true;
        }
        return false;
    }

    @Nullable
    public String getVote(VoteCategory<?> category) {
        return this.votes.get(category);
    }

    public boolean containsCategory(VoteCategory<?> category) {
        return this.votes.containsKey(category);
    }

    public String toString() {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (VoteCategory<?> category : this.votes.keySet()) {
            String part = category.getConfigName() + ": " + this.votes.get(category);
            result.add((CallSite)((Object)part));
        }
        return String.join((CharSequence)", ", result);
    }

    public static VoteTicket getVoteResult(Collection<VoteTicket> tickets) {
        HashMap maps = new HashMap();
        for (VoteTicket ticket : tickets) {
            for (VoteCategory<?> category : ticket.votes.keySet()) {
                Map categoryMap = maps.getOrDefault(category, new HashMap());
                String vote = ticket.votes.get(category);
                categoryMap.put(vote, categoryMap.getOrDefault(vote, 0) + 1);
                maps.put(category, categoryMap);
            }
        }
        VoteTicket outcome = new VoteTicket();
        for (VoteCategory category : maps.keySet()) {
            outcome.addVote(category, VoteTicket.getVoteWithHighestCount((Map)maps.get(category)));
        }
        return outcome;
    }

    private static String getVoteWithHighestCount(Map<String, Integer> values) {
        int currentCount;
        ArrayList<String> sortedCounts = new ArrayList<String>(values.keySet().stream().sorted(Comparator.comparingInt(a -> -((Integer)values.get(a)).intValue())).toList());
        int recordCount = values.get(sortedCounts.getFirst());
        for (int i = sortedCounts.size() - 1; i >= 0 && recordCount != (currentCount = values.get(sortedCounts.get(i)).intValue()); --i) {
            sortedCounts.remove(i);
        }
        return (String)sortedCounts.get((int)(Math.random() * (double)sortedCounts.size()));
    }
}

