/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.lib.api.Position;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.json.JsonDataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.json.JsonDataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.ExtraMath;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.AdvancementTask;
import io.github.steaf23.bingoreloaded.tasks.data.StatisticTask;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoCardMapRenderer
extends MapRenderer {
    BingoTeam team;
    private final TaskCard card;
    private final Random random;
    private final List<Position> stampOffsets;
    private static final Map<Key, BufferedImage> allItemImages = new HashMap<Key, BufferedImage>();
    private static final Set<Key> flatItems = new HashSet<Key>();
    private static BufferedImage COMPLETED_OVERLAY = null;
    private static BufferedImage BACKGROUND = null;
    private static BufferedImage ADVANCEMENT_ICON = null;
    private static BufferedImage STATISTIC_ICON = null;

    public BingoCardMapRenderer(ServerSoftware platform, TaskCard card, BingoTeam team) {
        this.card = card;
        this.random = new Random();
        this.stampOffsets = new ArrayList<Position>();
        for (int i = 0; i < card.size.fullCardSize; ++i) {
            this.stampOffsets.add(this.getStampOffset(0, 4));
        }
        if (!allItemImages.isEmpty()) {
            return;
        }
        try {
            InputStream iconStream;
            InputStream backgroundStream;
            JsonDataStorage atlas = new JsonDataStorage();
            JsonDataAccessor.readJsonFromFile(atlas, platform.getResource("taskimages/item_atlas.json"));
            DataStorage blocks = atlas.getStorage("blocks");
            DataStorage items = atlas.getStorage("items");
            if (items == null || blocks == null) {
                ConsoleMessenger.bug("Error loading task images from atlas.", (Object)this);
                return;
            }
            BingoCardMapRenderer.addImagesFromAtlas(platform.getResource("taskimages/blocks.png"), blocks, false);
            BingoCardMapRenderer.addImagesFromAtlas(platform.getResource("taskimages/items.png"), items, true);
            InputStream overlayStream = platform.getResource("taskimages/completed_slot.png");
            if (overlayStream != null) {
                COMPLETED_OVERLAY = ImageIO.read(overlayStream);
            }
            if ((backgroundStream = platform.getResource("taskimages/card_background.png")) != null) {
                BACKGROUND = ImageIO.read(backgroundStream);
            }
            if ((iconStream = platform.getResource("taskimages/advancement_icon.png")) != null) {
                ADVANCEMENT_ICON = ImageIO.read(iconStream);
            }
            if ((iconStream = platform.getResource("taskimages/statistic_icon.png")) != null) {
                STATISTIC_ICON = ImageIO.read(iconStream);
            }
        }
        catch (IOException e) {
            ConsoleMessenger.error(e.getMessage());
        }
        for (Material mat : Registry.MATERIAL.stream().toList()) {
            if (!mat.isItem() || mat.isAir() || allItemImages.containsKey(mat.getKey())) continue;
            ConsoleMessenger.warn("No task image found for item " + mat.name());
        }
        ConsoleMessenger.log("Added " + allItemImages.size() + " item images for use in the map renderer.");
    }

    private static void addImagesFromAtlas(InputStream atlas, DataStorage atlasInfo, boolean renderAsItems) throws IOException {
        List<String> itemNames = atlasInfo.getList("names", TagDataType.STRING);
        int rowCount = atlasInfo.getInt("rows", 1);
        List<Integer> sizeVec = atlasInfo.getList("texture_size", TagDataType.INT);
        int sizeX = sizeVec.get(0);
        int sizeY = sizeVec.get(1);
        BufferedImage image = ImageIO.read(atlas);
        int index = 0;
        for (String name : itemNames) {
            NamespacedKey nameKey = NamespacedKey.minecraft((String)name);
            BufferedImage subImage = image.getSubimage(index % rowCount * sizeX, index / rowCount * sizeY, sizeX, sizeY);
            ++index;
            allItemImages.put((Key)nameKey, subImage);
            if (!renderAsItems) continue;
            flatItems.add((Key)nameKey);
        }
    }

    public void render(@NotNull MapView mapView, @NotNull MapCanvas mapCanvas, @NotNull Player player) {
        int cardSize = this.card.size.size;
        List<GameTask> tasks = this.card.getTasks();
        int offsetFromTopLeft = (5 - cardSize) / 2;
        if (BACKGROUND != null) {
            mapCanvas.drawImage(0, 0, (Image)BACKGROUND);
        }
        for (int y = 0; y < cardSize; ++y) {
            for (int x = 0; x < cardSize; ++x) {
                GameTask task = tasks.get(y * cardSize + x);
                this.drawTaskOnGrid(mapCanvas, task, x + offsetFromTopLeft, y + offsetFromTopLeft, this.stampOffsets.get(y * cardSize + x));
            }
        }
    }

    public void drawTaskOnGrid(MapCanvas canvas, GameTask task, int gridX, int gridY, Position stampOffset) {
        Key key = task.data.getDisplayMaterial(CardDisplayInfo.DUMMY_DISPLAY_INFO).key();
        int amount = task.data.getRequiredAmount();
        int x = gridX * 24 + 4;
        int y = gridY * 24 + 4;
        int extraOffset = 1;
        if (!allItemImages.containsKey(key)) {
            return;
        }
        if (flatItems.contains(key)) {
            extraOffset = 4;
        }
        if (task.isCompleted() && task.getCompletedByTeam().isPresent() && COMPLETED_OVERLAY != null) {
            TextColor color = task.getCompletedByTeam().get().getColor();
            this.drawImageAlphaScissor(canvas, x, y, COMPLETED_OVERLAY, color);
        }
        this.drawImageAlphaScissor(canvas, x + extraOffset, y + extraOffset, allItemImages.get(key), null);
        if (amount > 1) {
            this.drawTaskAmount(canvas, gridX, gridY, amount);
        }
        if (task.data instanceof AdvancementTask) {
            this.drawImageAlphaScissor(canvas, x - 2, y + 11, ADVANCEMENT_ICON, null);
        } else if (task.data instanceof StatisticTask) {
            this.drawImageAlphaScissor(canvas, x - 2, y + 11, STATISTIC_ICON, null);
        }
    }

    private void drawTaskAmount(MapCanvas canvas, int gridX, int gridY, int amount) {
        String amountString = "" + amount;
        int xStartOffset = 0;
        if (amountString.length() == 1) {
            xStartOffset = 6;
        }
        canvas.drawText(gridX * 24 + 17 + xStartOffset, gridY * 24 + 21, (MapFont)MinecraftFont.Font, "\u00a747;" + amount);
        canvas.drawText(gridX * 24 + 16 + xStartOffset, gridY * 24 + 20, (MapFont)MinecraftFont.Font, "\u00a758;" + amount);
    }

    private void drawImageAlphaScissor(MapCanvas canvas, int x, int y, BufferedImage image, @Nullable TextColor modulate) {
        if (modulate == null) {
            for (int x2 = 0; x2 < image.getWidth(null); ++x2) {
                for (int y2 = 0; y2 < image.getHeight(null); ++y2) {
                    int alpha = image.getRGB(x2, y2) >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    canvas.setPixelColor(x + x2, y + y2, new Color(image.getRGB(x2, y2)));
                }
            }
            return;
        }
        Color modulateColor = new Color(modulate.red(), modulate.green(), modulate.blue());
        for (int x2 = 0; x2 < image.getWidth(null); ++x2) {
            for (int y2 = 0; y2 < image.getHeight(null); ++y2) {
                int alpha = image.getRGB(x2, y2) >> 24 & 0xFF;
                if (alpha == 0) continue;
                canvas.setPixelColor(x + x2, y + y2, ExtraMath.modulateColor(new Color(image.getRGB(x2, y2)), modulateColor));
            }
        }
    }

    private Position getStampOffset(int minOffset, int maxOffset) {
        int range = maxOffset - minOffset;
        Position randomVec = new Position(this.random.nextInt(range + 1), this.random.nextInt(range + 1), this.random.nextInt(range + 1));
        return randomVec.add(new Position(minOffset, minOffset, minOffset));
    }

    private void drawRect(MapCanvas canvas, int x, int y, int width, int height, TextColor color) {
        Color c = new Color(color.value());
        for (int loopY = y; loopY < y + height; ++loopY) {
            for (int loopX = x; loopX < x + width; ++loopX) {
                canvas.setPixelColor(loopX, loopY, c);
            }
        }
    }
}

