/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gui.inventory.EffectOptionsMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.GamemodeOptionsMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.KitOptionsMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.SettingsPresetMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.TeamSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.ComboBoxButtonAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.SpinBoxButtonAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.util.BingoPlayerSender;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class AdminBingoMenu
extends BasicMenu {
    private final BingoSession session;
    private static final int DURATION_MAX = 60;
    private static final int TEAMSIZE_MAX = 64;
    private static final Component COUNTDOWN_INPUT_LORE = InventoryMenu.inputButtonText(Component.text("Click")).append(Component.text("toggle countdown type"));
    private static final ItemTemplate START = new ItemTemplate(6, 0, ItemTypePaper.of(Material.LIME_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_START.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate END = new ItemTemplate(6, 0, ItemTypePaper.of(Material.RED_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_END.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate JOIN = new ItemTemplate(2, 0, ItemTypePaper.of(Material.WHITE_GLAZED_TERRACOTTA), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_TEAM.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate CARD = new ItemTemplate(1, 2, ItemTypePaper.of(Material.MAP), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_CARD.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate KIT = new ItemTemplate(3, 2, ItemTypePaper.of(Material.LEATHER_HELMET), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_KIT.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate MODE = new ItemTemplate(1, 4, ItemTypePaper.of(Material.ENCHANTED_BOOK), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_GAMEMODE.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate EFFECTS = new ItemTemplate(3, 4, ItemTypePaper.of(Material.POTION), BingoReloaded.applyTitleFormat(BingoMessage.OPTIONS_EFFECTS.asPhrase(new Component[0])), new Component[0]);
    private static final ItemTemplate COUNTDOWN_TYPE_DISABLED = new ItemTemplate(5, 2, ItemTypePaper.of(Material.COMPASS), BingoReloaded.applyTitleFormat("Countdown Disabled"), Component.text("No timer will be used to limit play time.")).addDescription("input", 10, COUNTDOWN_INPUT_LORE);
    private static final ItemTemplate COUNTDOWN_TYPE_DURATION = new ItemTemplate(5, 2, ItemTypePaper.of(Material.CLOCK), BingoReloaded.applyTitleFormat("Countdown Duration"), Component.text("Countdown timer will be enabled."), Component.text("The game will end after the timer runs out,"), Component.text("this removes the win goal condition from Hot-Swap and Complete-X.")).addDescription("input", 10, COUNTDOWN_INPUT_LORE);
    private static final ItemTemplate COUNTDOWN_TYPE_LIMIT = new ItemTemplate(5, 2, ItemTypePaper.of(Material.RECOVERY_COMPASS), BingoReloaded.applyTitleFormat("Countdown Time Limit"), Component.text("Countdown timer will be enabled."), Component.text("Any goal is still a valid win condition,"), Component.text("but the game will end after the timer runs out.")).addDescription("input", 10, COUNTDOWN_INPUT_LORE);
    private static final ItemTemplate DURATION = new ItemTemplate(5, 4, ItemTypePaper.of(Material.RECOVERY_COMPASS), BingoReloaded.applyTitleFormat("Countdown Duration"), new Component[0]);
    private static final ItemTemplate TEAM_SIZE = new ItemTemplate(7, 2, ItemTypePaper.of(Material.ENDER_EYE), BingoReloaded.applyTitleFormat("Maximum Team Size"), new Component[0]);
    private static final ItemTemplate PRESETS = new ItemTemplate(7, 4, ItemTypePaper.of(Material.CHEST_MINECART), BingoReloaded.applyTitleFormat("Setting Presets"), new Component[0]);

    public AdminBingoMenu(MenuBoard menuBoard, BingoSession session) {
        super(menuBoard, BingoMessage.OPTIONS_TITLE.asPhrase(new Component[0]), 6);
        this.session = session;
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        super.beforeOpening(player);
        BingoSettings view = this.session.settingsBuilder.view();
        Component selected = ((TextComponent)Component.text("Selected: ").color(NamedTextColor.YELLOW)).decorate(TextDecoration.ITALIC);
        BingoSettings settings = this.session.settingsBuilder.view();
        ItemTemplate cardItem = CARD.copy().setLore(selected, Component.text(" - ").append(Component.text(settings.card())));
        ItemTemplate kitItem = KIT.copy().setLore(selected, Component.text(" - ").append(settings.kit().getDisplayName()));
        ArrayList<Component> modeLore = new ArrayList<Component>();
        modeLore.add(selected);
        modeLore.add(Component.text(" - ").append(settings.mode().asComponent()));
        modeLore.add(Component.text("   Size: ").append(settings.size().asComponent()));
        switch (settings.mode()) {
            case HOTSWAP: {
                modeLore.add(Component.text("   Win goal: ").append(Component.text(settings.hotswapGoal())));
                modeLore.add(settings.expireHotswapTasks() ? Component.text("   Tasks expire").color(NamedTextColor.RED) : Component.text("   Tasks do not expire").color(NamedTextColor.GRAY));
                break;
            }
            case REGULAR: {
                modeLore.add(settings.differentCardPerTeam() ? Component.text("   Different cards generated").color(NamedTextColor.RED) : Component.text("   Same cards generated").color(NamedTextColor.GRAY));
                break;
            }
            case COMPLETE: {
                modeLore.add(Component.text("   Win goal: ").append(Component.text(settings.completeGoal())));
                modeLore.add(settings.differentCardPerTeam() ? Component.text("   Different cards generated").color(NamedTextColor.RED) : Component.text("   Same cards generated").color(NamedTextColor.GRAY));
            }
        }
        ItemTemplate modeItem = MODE.copy().setLore(modeLore.toArray(new Component[0]));
        ArrayList<Component> effects = new ArrayList<Component>(List.of(EffectOptionFlags.effectsToText(settings.effects())));
        effects.addFirst(selected);
        ItemTemplate effectsItem = EFFECTS.copy().setLore(effects.toArray(new Component[0]));
        this.addAction(JOIN, arguments -> {
            TeamSelectionMenu selectionMenu = new TeamSelectionMenu(this.getMenuBoard(), this.session);
            selectionMenu.open(arguments.player());
        });
        this.addAction(kitItem, arguments -> new KitOptionsMenu(this.getMenuBoard(), this.session).open(arguments.player()));
        this.addAction(modeItem, arguments -> new GamemodeOptionsMenu(this.getMenuBoard(), this.session).open(arguments.player()));
        this.addAction(cardItem, this::openCardPicker);
        this.addAction(effectsItem, arguments -> new EffectOptionsMenu(this.getMenuBoard(), this.session.settingsBuilder).open(arguments.player()));
        this.addAction(PRESETS, arguments -> new SettingsPresetMenu(this.getMenuBoard(), this.session.settingsBuilder).open(arguments.player()));
        ItemTemplate teamSizeItem = TEAM_SIZE.copy();
        int maxTeamSize = view.maxTeamSize();
        this.updateTeamSizeLore(teamSizeItem, maxTeamSize);
        SpinBoxButtonAction teamSizeAction = new SpinBoxButtonAction(1, 64, maxTeamSize, value -> {
            this.session.settingsBuilder.maxTeamSize((int)value);
            this.updateTeamSizeLore(teamSizeItem, (int)value);
        });
        ((MenuAction)teamSizeAction).setItem(teamSizeItem);
        ItemTemplate durationItem = DURATION.copy();
        int duration = view.countdownDuration();
        this.updateDurationLore(durationItem, duration);
        SpinBoxButtonAction durationAction = new SpinBoxButtonAction(1, 60, duration, value -> {
            this.session.settingsBuilder.countdownGameDuration((int)value);
            this.updateDurationLore(durationItem, (int)value);
        });
        ((MenuAction)durationAction).setItem(durationItem);
        ComboBoxButtonAction countdownAction = new ComboBoxButtonAction.Builder("DISABLED", COUNTDOWN_TYPE_DISABLED.copy()).addOption("DURATION", COUNTDOWN_TYPE_DURATION.copy()).addOption("TIME_LIMIT", COUNTDOWN_TYPE_LIMIT.copy()).setCallback((oldValue, newValue, arguments) -> {
            this.session.settingsBuilder.countdownType(BingoSettings.CountdownType.valueOf(newValue));
            return true;
        }).buildAction(COUNTDOWN_TYPE_DISABLED.getSlot(), view.countdownType().name());
        this.addActions(teamSizeAction, durationAction, countdownAction);
        ComboBoxButtonAction startAction = new ComboBoxButtonAction.Builder("start", START.copy()).addOption("end", END.copy()).setCallback((clickedValue, newValue, args) -> {
            if (clickedValue.equals("start")) {
                if (!this.session.startGame()) {
                    BingoPlayerSender.sendMessage(Component.text("Could not start game, see console for details.").color(NamedTextColor.RED), (Audience)args.player());
                    return false;
                }
                return true;
            }
            if (clickedValue.equals("end")) {
                this.session.endGame();
                return true;
            }
            return false;
        }).buildAction(ItemTemplate.slotFromXY(6, 0), this.session.isRunning() ? "end" : "start");
        this.addAction(startAction);
    }

    private void openCardPicker(MenuAction.ActionArguments arguments) {
        PlayerHandle player = arguments.player();
        BingoCardData cardsData = new BingoCardData();
        ArrayList<ItemTemplate> cards = new ArrayList<ItemTemplate>();
        for (String cardName : cardsData.getCardNames()) {
            cards.add(new ItemTemplate(ItemTypePaper.of(Material.PAPER), Component.text(cardName), BingoMessage.LIST_COUNT.asPhrase(Component.text(cardsData.getListNames(cardName).size()).color(NamedTextColor.DARK_PURPLE))));
        }
        PaginatedSelectionMenu cardPicker = new PaginatedSelectionMenu(this.getMenuBoard(), Component.text("Choose A Card"), cards, FilterType.DISPLAY_NAME){

            @Override
            public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
                String name = clickedOption.getPlainTextName();
                if (!name.isEmpty()) {
                    AdminBingoMenu.this.cardSelected(name);
                }
                this.close(player);
            }
        };
        cardPicker.open(player);
    }

    private void cardSelected(String cardName) {
        if (cardName == null) {
            return;
        }
        this.session.settingsBuilder.card(cardName);
    }

    private void updateDurationLore(ItemTemplate item, int duration) {
        item.setLore(Component.text("Timer set to " + duration + " minutes(s)"), Component.text("for bingo games on countdown mode"));
    }

    private void updateTeamSizeLore(ItemTemplate item, int value) {
        item.setLore(((TextComponent)Component.text("Selected:").color(NamedTextColor.YELLOW)).decorate(TextDecoration.ITALIC), Component.text(" - ").append(Component.text(value)));
        item.addDescription("warning", 1, Component.text("(When changing this setting all currently").color(NamedTextColor.GRAY), Component.text("joined players will be kicked from their teams!)").color(NamedTextColor.GRAY));
    }
}

