/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.BingoSettingsBuilder;
import java.util.EnumSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;

public class EffectOptionsMenu
extends BasicMenu {
    private final EnumSet<EffectOptionFlags> flags;
    private final BingoSettingsBuilder settingsBuilder;

    public EffectOptionsMenu(MenuBoard menuBoard, BingoSettingsBuilder settings) {
        super(menuBoard, BingoMessage.OPTIONS_EFFECTS.asPhrase(new Component[0]), 6);
        this.settingsBuilder = settings;
        this.flags = settings.view().effects();
        for (int i = 0; i < 8; ++i) {
            this.addItem(BLANK.copyToSlot(i, 5));
        }
        this.addEffectAction(EffectOptionFlags.NIGHT_VISION, 5, 3, Material.GOLDEN_CARROT);
        this.addEffectAction(EffectOptionFlags.WATER_BREATHING, 3, 3, Material.PUFFERFISH);
        this.addEffectAction(EffectOptionFlags.FIRE_RESISTANCE, 7, 3, Material.MAGMA_CREAM);
        this.addEffectAction(EffectOptionFlags.NO_FALL_DAMAGE, 2, 1, Material.NETHERITE_BOOTS);
        this.addEffectAction(EffectOptionFlags.SPEED, 1, 3, Material.FEATHER);
        this.addEffectAction(EffectOptionFlags.NO_DURABILITY, 6, 1, Material.NETHERITE_PICKAXE);
        this.addEffectAction(EffectOptionFlags.KEEP_INVENTORY, 4, 1, Material.CHEST);
        this.addCloseAction(new ItemTemplate(8, 5, ItemTypePaper.of(Material.DIAMOND), BingoMessage.MENU_SAVE_EXIT.asPhrase(new Component[0]).color(NamedTextColor.AQUA).decorate(TextDecoration.BOLD), new Component[0]));
    }

    private void addEffectAction(EffectOptionFlags flag, int slotX, int slotY, Material material) {
        ItemTemplate item = new ItemTemplate(slotX, slotY, ItemTypePaper.of(material), null, new Component[0]);
        this.updateUI(flag, item);
        this.addAction(item, player -> {
            this.toggleOption(flag);
            this.updateUI(flag, item);
        });
    }

    private void toggleOption(EffectOptionFlags flag) {
        if (this.flags.contains((Object)flag)) {
            this.flags.remove((Object)flag);
        } else {
            this.flags.add(flag);
        }
    }

    public void updateUI(EffectOptionFlags flag, ItemTemplate item) {
        if (this.flags.contains((Object)flag)) {
            item.setName((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(flag.name, Component.text(" "), BingoMessage.EFFECTS_ENABLED.asPhrase(new Component[0]))).color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD)).build());
            item.setLore(BingoMessage.EFFECTS_DISABLE.asMultiline(NamedTextColor.GREEN, new Component[0]));
        } else {
            item.setName((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(flag.name, Component.text(" "), BingoMessage.EFFECTS_DISABLED.asPhrase(new Component[0]))).color(NamedTextColor.RED)).decorate(TextDecoration.BOLD)).build());
            item.setLore(BingoMessage.EFFECTS_ENABLE.asMultiline(NamedTextColor.RED, new Component[0]));
        }
    }

    @Override
    public void beforeClosing(PlayerHandle player) {
        this.settingsBuilder.effects(this.flags);
        super.beforeClosing(player);
    }
}

