/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.ComboBoxButtonAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.SpinBoxButtonAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.ToggleButtonAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.BingoSettingsBuilder;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;

public class GamemodeOptionsMenu
extends BasicMenu {
    private final BingoSession session;

    public GamemodeOptionsMenu(MenuBoard menuBoard, BingoSession session) {
        super(menuBoard, (Component)Component.text("Select Gamemode"), 1);
        this.session = session;
        this.addAction(new ItemTemplate(1, ItemTypePaper.of(Material.LIME_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.MODE_REGULAR.asPhrase(new Component[0])), new Component[0]), arguments -> this.selectGamemode(arguments.player(), BingoGamemode.REGULAR));
        this.addAction(new ItemTemplate(3, ItemTypePaper.of(Material.MAGENTA_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.MODE_LOCKOUT.asPhrase(new Component[0])), new Component[0]), arguments -> this.selectGamemode(arguments.player(), BingoGamemode.LOCKOUT));
        this.addAction(new ItemTemplate(5, ItemTypePaper.of(Material.LIGHT_BLUE_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.MODE_COMPLETE.asPhrase(new Component[0])), new Component[0]), arguments -> this.selectGamemode(arguments.player(), BingoGamemode.COMPLETE));
        this.addAction(new ItemTemplate(7, ItemTypePaper.of(Material.ORANGE_CONCRETE), BingoReloaded.applyTitleFormat(BingoMessage.MODE_HOTSWAP.asPhrase(new Component[0])), new Component[0]), arguments -> this.selectGamemode(arguments.player(), BingoGamemode.HOTSWAP));
    }

    public void selectGamemode(PlayerHandle player, BingoGamemode chosenMode) {
        BasicMenu optionMenu = new BasicMenu(this.getMenuBoard(), (Component)Component.text("Select Gamemode Options"), 1);
        ArrayList<Consumer<BingoSettingsBuilder>> additionalOptions = new ArrayList<Consumer<BingoSettingsBuilder>>();
        Component toggleInput = InventoryMenu.INPUT_LEFT_CLICK.append(Component.text("toggle option"));
        ComboBoxButtonAction cardSizeAction = new ComboBoxButtonAction.Builder("3", new ItemTemplate(ItemTypePaper.of(Material.RABBIT_HIDE), BingoReloaded.applyTitleFormat("Small card (3x3)"), new Component[0]).addDescription("input", 10, toggleInput)).addOption("5", new ItemTemplate(ItemTypePaper.of(Material.LEATHER), BingoReloaded.applyTitleFormat("Big card (5x5)"), new Component[0]).addDescription("input", 10, toggleInput)).buildAction(3, this.session.settingsBuilder.view().size() == CardSize.X5 ? "5" : "3");
        optionMenu.addAction(cardSizeAction);
        if (chosenMode == BingoGamemode.COMPLETE) {
            int completeGoal = this.session.settingsBuilder.view().completeGoal();
            ItemTemplate completeGoalItem = new ItemTemplate(5, ItemTypePaper.of(Material.RECOVERY_COMPASS), BingoReloaded.applyTitleFormat("Complete-X Win Score"), Component.text("Complete " + completeGoal + " tasks to win complete-x."), Component.text("Only effective if countdown mode is disabled"));
            goalAction = new SpinBoxButtonAction(1, 64, completeGoal, value -> {
                this.session.settingsBuilder.completeGoal((int)value);
                completeGoalItem.setLore(ComponentUtils.createComponentsFromString("Complete " + value + " tasks to win complete-x.", "Only effective if countdown mode is disabled"));
            });
            optionMenu.addItem(completeGoalItem, goalAction);
        } else if (chosenMode == BingoGamemode.HOTSWAP) {
            int hotswapGoal = this.session.settingsBuilder.view().hotswapGoal();
            ItemTemplate hotswapGoalItem = new ItemTemplate(5, ItemTypePaper.of(Material.FIRE_CHARGE), BingoReloaded.applyTitleFormat("Hot-Swap Win Score"), Component.text("Complete " + hotswapGoal + " tasks to win hot-swap."), Component.text("Only effective if countdown mode is disabled"));
            goalAction = new SpinBoxButtonAction(1, 64, hotswapGoal, value -> {
                this.session.settingsBuilder.hotswapGoal((int)value);
                hotswapGoalItem.setLore(ComponentUtils.createComponentsFromString("Complete " + value + " tasks to win hot-swap.", "Only effective if countdown mode is disabled"));
            });
            optionMenu.addItem(hotswapGoalItem, goalAction);
            additionalOptions.add(settings -> settings.hotswapGoal(goalAction.getValue()));
            boolean expireTasks = this.session.settingsBuilder.view().expireHotswapTasks();
            ItemTemplate hotswapExpireItem = new ItemTemplate(6, ItemTypePaper.of(Material.ROTTEN_FLESH), BingoReloaded.applyTitleFormat("Expire tasks automatically"), new Component[0]);
            GamemodeOptionsMenu.updateExpireTasksEnabledVisual(hotswapExpireItem, expireTasks);
            ToggleButtonAction toggleExpireTasksAction = new ToggleButtonAction(expireTasks, newValue -> {
                this.session.settingsBuilder.expireHotswapTasks((boolean)newValue);
                GamemodeOptionsMenu.updateExpireTasksEnabledVisual(hotswapExpireItem, newValue);
            });
            optionMenu.addItem(hotswapExpireItem, toggleExpireTasksAction);
            additionalOptions.add(settings -> settings.expireHotswapTasks(toggleExpireTasksAction.getValue()));
        }
        if (chosenMode == BingoGamemode.REGULAR || chosenMode == BingoGamemode.COMPLETE) {
            int slot = chosenMode == BingoGamemode.REGULAR ? 5 : 6;
            boolean separateGeneration = this.session.settingsBuilder.view().differentCardPerTeam();
            ItemTemplate separateGenerationItem = new ItemTemplate(slot, ItemTypePaper.of(Material.GLOBE_BANNER_PATTERN));
            GamemodeOptionsMenu.updateSeparateGenerationVisual(separateGenerationItem, separateGeneration);
            ToggleButtonAction separateGenerationAction = new ToggleButtonAction(separateGeneration, newValue -> {
                this.session.settingsBuilder.differentCardPerTeam((boolean)newValue);
                GamemodeOptionsMenu.updateSeparateGenerationVisual(separateGenerationItem, newValue);
            });
            optionMenu.addItem(separateGenerationItem, separateGenerationAction);
            additionalOptions.add(settings -> settings.differentCardPerTeam(separateGenerationAction.getValue()));
        }
        optionMenu.addCloseAction(new ItemTemplate(0, ItemTypePaper.of(Material.REDSTONE), BingoMessage.MENU_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]));
        optionMenu.addAction(GamemodeOptionsMenu.getSaveButton(chosenMode, 8), args -> {
            CardSize size = CardSize.X5;
            MenuAction action = cardSizeAction;
            if (action instanceof ComboBoxButtonAction) {
                ComboBoxButtonAction comboAction = (ComboBoxButtonAction)action;
                size = comboAction.getSelectedOptionName().equals("5") ? CardSize.X5 : CardSize.X3;
            }
            this.session.settingsBuilder.mode(chosenMode);
            this.session.settingsBuilder.cardSize(size);
            for (Consumer option : additionalOptions) {
                option.accept(this.session.settingsBuilder);
            }
            optionMenu.close(player);
            this.close(player);
        });
        optionMenu.open(player, true);
    }

    private static void updateExpireTasksEnabledVisual(ItemTemplate item, boolean enabled) {
        if (enabled) {
            item.setName(BingoReloaded.applyTitleFormat("Expire tasks automatically"));
            item.setLore(new Component[]{Component.text("Tasks always expire when they get completed, however..."), ComponentUtils.MINI_BUILDER.deserialize("Tasks <red>EXPIRE</red> automatically after some random amount of time")});
        } else {
            item.setName(BingoReloaded.applyTitleFormat("Do NOT expire tasks automatically"));
            item.setLore(new Component[]{Component.text("Tasks always expire when they get completed, however..."), ComponentUtils.MINI_BUILDER.deserialize("Tasks <gray>DO NOT EXPIRE</gray> automatically after some random amount of time")});
        }
    }

    private static void updateSeparateGenerationVisual(ItemTemplate item, boolean enabled) {
        if (enabled) {
            item.setName(BingoReloaded.applyTitleFormat("Different tasks generated per team"));
            item.setLore(new Component[]{ComponentUtils.MINI_BUILDER.deserialize("Different teams get <red>DIFFERENT</red> cards")});
        } else {
            item.setName(BingoReloaded.applyTitleFormat("Same tasks generated for everyone"));
            item.setLore(new Component[]{ComponentUtils.MINI_BUILDER.deserialize("Different teams get <gray>THE SAME</gray> cards")});
        }
    }

    private static ItemTemplate getSaveButton(BingoGamemode mode, int slot) {
        return new ItemTemplate(slot, ItemTypePaper.of(Material.EMERALD), ((TextComponent)((TextComponent)((TextComponent)Component.text("Play ").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD)).append(mode.asComponent())).append(Component.text(" with selected options")), new Component[0]);
    }
}

