/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoSettingsData;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.dialog.TextInputDialog;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.UserInputMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.settings.BingoSettingsBuilder;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class SettingsPresetMenu
extends PaginatedSelectionMenu {
    private final BingoSettingsBuilder settingsBuilder;
    private final BingoSettingsData settingsData = new BingoSettingsData();
    private static final ItemTemplate SAVE_PRESET = new ItemTemplate(51, ItemTypePaper.of(Material.EMERALD), ((TextComponent)Component.text("Add preset from current settings").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), new Component[0]);

    public SettingsPresetMenu(MenuBoard board, BingoSettingsBuilder settingsBuilder) {
        super(board, (Component)Component.text("Setting Presets"), new ArrayList<ItemTemplate>(), FilterType.ITEM_ID);
        this.settingsBuilder = settingsBuilder;
    }

    @Override
    public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
        if (event.isLeftClick()) {
            this.settingsBuilder.fromOther(this.settingsData.getSettings(clickedOption.getCompareKey()));
            this.close(player);
        } else if (event.isRightClick()) {
            BasicMenu context = new BasicMenu(this.getMenuBoard(), clickedOption.getName(), 1);
            context.addAction(new ItemTemplate(0, ItemTypePaper.of(Material.BARRIER), BingoReloaded.applyTitleFormat("Remove"), new Component[0]), clickType -> {
                this.settingsData.removeSettings(clickedOption.getCompareKey());
                context.close(player);
            });
            context.addAction(new ItemTemplate(1, ItemTypePaper.of(Material.SHULKER_SHELL), BingoReloaded.applyTitleFormat("Duplicate"), new Component[0]), clickType -> {
                BingoSettings oldSettings = this.settingsData.getSettings(clickedOption.getCompareKey());
                this.settingsData.saveSettings(clickedOption.getCompareKey() + "_copy", oldSettings);
                context.close(player);
            });
            context.addAction(new ItemTemplate(2, ItemTypePaper.of(Material.NAME_TAG), BingoReloaded.applyTitleFormat("Rename"), new Component[0]), clickType -> {
                BingoSettings oldSettings = this.settingsData.getSettings(clickedOption.getCompareKey());
                this.settingsData.removeSettings(clickedOption.getCompareKey());
                new TextInputDialog(this.getMenuBoard(), clickedOption.getCompareKey(), input -> {
                    this.settingsData.saveSettings((String)input, oldSettings);
                    context.close(player);
                }, Component.text("Rename preset to:"), null).open(player);
            });
            context.addAction(new ItemTemplate(3, ItemTypePaper.of(Material.GLOBE_BANNER_PATTERN), BingoReloaded.applyTitleFormat("Overwrite"), Component.text("This will overwrite the settings saved in "), Component.text(clickedOption.getCompareKey() + " with the currently selected options!")), clickType -> {
                this.settingsData.saveSettings(clickedOption.getCompareKey(), this.settingsBuilder.view());
                context.close(player);
            });
            context.addAction(new ItemTemplate(4, ItemTypePaper.of(Material.AMETHYST_SHARD), BingoReloaded.applyTitleFormat("Set As Default"), new Component[0]), clickType -> {
                this.settingsData.setDefaultSettings(clickedOption.getCompareKey());
                context.close(player);
            });
            context.addCloseAction(new ItemTemplate(8, ItemTypePaper.of(Material.DIAMOND), BingoReloaded.applyTitleFormat("Exit"), new Component[0])).open(player);
        }
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        this.addAction(SAVE_PRESET, arguments -> new UserInputMenu(this.getMenuBoard(), Component.text("Rename preset..."), input -> {
            this.settingsData.saveSettings((String)input, this.settingsBuilder.view());
            this.beforeOpening(arguments.player());
        }, "my_settings").open(player));
        this.clearItems();
        ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
        for (String preset : this.settingsData.getPresetNames()) {
            boolean def = preset.equals(this.settingsData.getDefaultSettingsName());
            Component name = LegacyComponentSerializer.legacySection().deserialize(preset);
            if (def) {
                name = name.append(Component.text(" (default)").color(NamedTextColor.LIGHT_PURPLE));
            }
            ItemTemplate item = new ItemTemplate(ItemTypePaper.of(Material.GLOBE_BANNER_PATTERN), name, new Component[0]).addDescription("input", 5, InventoryMenu.INPUT_LEFT_CLICK.append(Component.text("apply this preset")), InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("more options"))).setCompareKey(preset);
            items.add(item);
        }
        this.addItemsToSelect(items);
        super.beforeOpening(player);
    }

    @Override
    public void beforeClosing(PlayerHandle player) {
        this.settingsBuilder.settingsUpdated();
        super.beforeClosing(player);
    }
}

