/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.ColorPickerMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.NameEditAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class TeamEditorMenu
extends PaginatedSelectionMenu {
    private final TeamData teamData = new TeamData();
    private static final TeamData.TeamTemplate DEFAULT_NEW_TEAM = new TeamData.TeamTemplate("MyTeam", TextColor.fromHexString("#808080"));
    private static final ItemTemplate RESTORE_DEFAULT = new ItemTemplate(2, 5, ItemTypePaper.of(Material.TNT), ((TextComponent)Component.text("Restore Default Teams").color(NamedTextColor.RED)).decorate(TextDecoration.BOLD), Component.text("This option will remove all created teams!"));
    private static final ItemTemplate CREATE_TEAM = new ItemTemplate(6, 5, ItemTypePaper.of(Material.EMERALD), ((TextComponent)Component.text("Create New Team").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), new Component[0]);

    public TeamEditorMenu(MenuBoard manager) {
        super(manager, (Component)Component.text("Edit Teams"), new ArrayList<ItemTemplate>(), FilterType.DISPLAY_NAME);
        this.addAction(RESTORE_DEFAULT, arguments -> {
            this.teamData.reset();
            this.updateDisplay();
        });
        this.addAction(CREATE_TEAM, arguments -> this.createTeamEditor("").open(arguments.player()));
    }

    public void updateDisplay() {
        this.clearFilter();
        this.clearItems();
        ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
        Map<String, TeamData.TeamTemplate> teamMap = this.teamData.getTeams();
        for (String key : teamMap.keySet()) {
            TeamData.TeamTemplate template = teamMap.get(key);
            items.add(ItemTemplate.createColoredLeather(template.color(), ItemTypePaper.of(Material.LEATHER_HELMET)).setName(template.nameComponent().color(template.color()).decorate(TextDecoration.BOLD)).setLore(Component.text("id: ").append(((TextComponent)Component.text(key).color(NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC))).setCompareKey(key).addDescription("input", 5, InventoryMenu.INPUT_LEFT_CLICK.append(Component.text("edit team")), InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("remove team"))));
        }
        this.addItemsToSelect(items);
    }

    public BasicMenu createTeamEditor(@NotNull String teamKey) {
        return new TeamEdit(this.getMenuBoard(), this.teamData.getTeam(teamKey, DEFAULT_NEW_TEAM), editedTemplate -> this.teamData.addTeam(teamKey, (TeamData.TeamTemplate)editedTemplate));
    }

    @Override
    public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
        String key = clickedOption.getCompareKey();
        if (event.getClick() == ClickType.RIGHT) {
            this.teamData.removeTeam(key);
            this.updateDisplay();
        } else {
            this.createTeamEditor(key).open(player);
        }
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        this.updateDisplay();
        super.beforeOpening(player);
    }

    static class TeamEdit
    extends BasicMenu {
        private final Consumer<TeamData.TeamTemplate> finishedCallback;
        private TeamData.TeamTemplate templateToEdit;

        public TeamEdit(MenuBoard manager, TeamData.TeamTemplate teamToEdit, Consumer<TeamData.TeamTemplate> callback) {
            super(manager, (Component)Component.text("Edit team"), 3);
            this.templateToEdit = teamToEdit;
            this.finishedCallback = callback;
            this.addAction(this.getTeamNameAction());
            ItemTemplate teamColorItem = new ItemTemplate(4, 1, ItemTypePaper.of(Material.LEATHER_CHESTPLATE), ((TextComponent)Component.text("Color").color(this.templateToEdit.color())).decorate(TextDecoration.BOLD), new Component[0]).setLeatherColor(this.templateToEdit.color());
            this.addAction(teamColorItem, args -> new ColorPickerMenu(this.getMenuBoard(), (Component)Component.text("Pick team color"), result -> {
                this.templateToEdit = new TeamData.TeamTemplate(this.templateToEdit.stringName(), (TextColor)result);
                teamColorItem.setLeatherColor(this.templateToEdit.color()).setName(((TextComponent)Component.text("Color").color(this.templateToEdit.color())).decorate(TextDecoration.BOLD));
                this.addItem(teamColorItem);
            }).open(args.player()));
            this.addCloseAction(new ItemTemplate(6, 1, ItemTypePaper.of(Material.BARRIER), BingoMessage.MENU_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]));
        }

        @NotNull
        private MenuAction getTeamNameAction() {
            ItemTemplate teamNameItem = new ItemTemplate(2, 1, ItemTypePaper.of(Material.WRITABLE_BOOK), this.templateToEdit.nameComponent(), ((TextComponent)Component.text("Supports minimessage formatting").color(NamedTextColor.AQUA)).decorate(TextDecoration.ITALIC));
            NameEditAction action = new NameEditAction(Component.text("Edit team name"), this.getMenuBoard(), this.templateToEdit.stringName(), (value, item) -> {
                this.templateToEdit = new TeamData.TeamTemplate((String)value, this.templateToEdit.color());
                this.addItem((ItemTemplate)item);
            });
            action.setItem(teamNameItem);
            return action;
        }

        @Override
        public void beforeClosing(PlayerHandle player) {
            super.beforeClosing(player);
            this.finishedCallback.accept(this.templateToEdit);
        }
    }
}

