/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class TeamSelectionMenu
extends PaginatedSelectionMenu {
    private final BingoSession session;
    private final TeamManager teamManager;
    private static final Component PLAYER_PREFIX = ComponentUtils.MINI_BUILDER.deserialize("<gray><bold> \u2517 </bold></gray><white>");

    public TeamSelectionMenu(MenuBoard manager, BingoSession session) {
        super(manager, BingoMessage.OPTIONS_TEAM.asPhrase(new Component[0]), new ArrayList<ItemTemplate>(), FilterType.NONE);
        this.session = session;
        this.teamManager = session.teamManager;
    }

    @Override
    public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
        BingoParticipant participant = this.teamManager.getPlayerAsParticipant(player);
        if (participant == null) {
            participant = new BingoPlayer(player, this.session);
        }
        if (clickedOption.getCompareKey().equals("item_auto")) {
            this.teamManager.addMemberToTeam(participant, "auto");
            this.reopen(player);
            return;
        }
        if (clickedOption.getCompareKey().equals("item_leave")) {
            this.teamManager.removeMemberFromTeam(participant);
            this.reopen(player);
            return;
        }
        this.teamManager.addMemberToTeam(participant, clickedOption.getCompareKey());
        this.reopen(player);
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        super.beforeOpening(player);
        ArrayList<ItemTemplate> optionItems = new ArrayList<ItemTemplate>();
        ItemTemplate autoItem = new ItemTemplate(ItemTypePaper.of(Material.NETHER_STAR), (Component)BingoMessage.TEAM_AUTO.asPhrase(new Component[0]).color(TextColor.fromHexString("#fdffa8")).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), new Component[0]).setCompareKey("item_auto");
        if (player instanceof Player) {
            Player gamePlayer = (Player)player;
            Optional<BingoTeam> autoTeamOpt = this.teamManager.getActiveTeams().getTeams().stream().filter(t -> t.getIdentifier().equals("auto")).findAny();
            if (autoTeamOpt.isEmpty()) {
                ConsoleMessenger.error("Cannot find any teams to join! Wait for the game to re-open (if it still happens after the game is re-opened, Please report!)");
                return;
            }
            BingoTeam autoTeam = autoTeamOpt.get();
            boolean playerInAutoTeam = autoTeam.hasMember(player.uniqueId());
            int autoTeamMemberCount = autoTeam.getMembers().size();
            ArrayList<Component> description = new ArrayList<Component>();
            if (playerInAutoTeam) {
                description.add(PLAYER_PREFIX.append(gamePlayer.displayName()));
                description.add(Component.text(" "));
                description.add(BingoMessage.COUNT_MORE.asPhrase(Component.text(Integer.toString(autoTeamMemberCount - 1))).color(NamedTextColor.GRAY));
            } else {
                description.add(BingoMessage.COUNT_MORE.asPhrase(Component.text(Integer.toString(autoTeamMemberCount))).color(NamedTextColor.GRAY));
            }
            autoItem.setLore((Component[])description.toArray(Component[]::new));
        }
        optionItems.add(autoItem);
        optionItems.add(new ItemTemplate(ItemTypePaper.of(Material.TNT), (Component)BingoMessage.OPTIONS_LEAVE.asPhrase(new Component[0]).color(NamedTextColor.AQUA).decorate(TextDecoration.BOLD, TextDecoration.ITALIC), new Component[0]).setGlowing(true).setCompareKey("item_leave"));
        Map<String, TeamData.TeamTemplate> allTeams = this.teamManager.getJoinableTeams();
        for (String teamId : allTeams.keySet()) {
            boolean playersTeam = false;
            TeamData.TeamTemplate teamTemplate = allTeams.get(teamId);
            boolean teamIsFull = false;
            ArrayList<Component> players = new ArrayList<Component>();
            for (BingoTeam team : this.teamManager.getActiveTeams()) {
                if (!team.getIdentifier().equals(teamId)) continue;
                for (BingoParticipant participant : team.getMembers()) {
                    players.add(PLAYER_PREFIX.append(participant.getDisplayName()));
                    if (!participant.getId().equals(player.uniqueId())) continue;
                    playersTeam = true;
                }
                if (this.teamManager.getMaxTeamSize() != team.getMembers().size()) continue;
                teamIsFull = true;
            }
            Component teamStatus = teamIsFull ? BingoMessage.FULL_TEAM_DESC.asPhrase(new Component[0]).color(NamedTextColor.RED) : BingoMessage.JOIN_TEAM_DESC.asPhrase(new Component[0]).color(NamedTextColor.GREEN);
            optionItems.add(ItemTemplate.createColoredLeather(teamTemplate.color(), ItemTypePaper.of(Material.LEATHER_HELMET)).setName(teamTemplate.nameComponent().color(teamTemplate.color()).decorate(TextDecoration.BOLD)).setLore((Component[])players.toArray(Component[]::new)).setCompareKey(teamId).setGlowing(playersTeam).addDescription("status", 1, teamStatus));
        }
        this.clearItems();
        this.addItemsToSelect(optionItems);
    }
}

