/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.gameloop.phase.PregameLobby;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.util.CollectionHelper;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;

public class VoteMenu
extends BasicMenu {
    private final PregameLobby lobby;
    private static final int[][] categoryPositions = new int[][]{{4}, {3, 5}, {2, 4, 6}, {1, 3, 5, 7}};
    private static final ItemTemplate EXIT = new ItemTemplate(8, ItemTypePaper.of(Material.BARRIER), BingoMessage.MENU_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);

    public VoteMenu(MenuBoard menuBoard, BingoConfigurationData.VoteList voteList, PregameLobby lobbyPhase) {
        super(menuBoard, BingoMessage.OPTIONS_VOTE.asPhrase(new Component[0]), 3);
        int itemIndex;
        this.lobby = lobbyPhase;
        int categoryMax = 0;
        int categoryIndex = 0;
        if (!voteList.cards().isEmpty()) {
            ++categoryMax;
        }
        if (!voteList.gamemodes().isEmpty()) {
            ++categoryMax;
        }
        if (!voteList.kits().isEmpty()) {
            ++categoryMax;
        }
        if (!voteList.cardSizes().isEmpty()) {
            ++categoryMax;
        }
        if (categoryMax == 0) {
            return;
        }
        int[] positions = categoryPositions[categoryMax - 1];
        if (!voteList.gamemodes().isEmpty()) {
            BasicMenu gamemodeOptions = new BasicMenu(menuBoard, BingoMessage.VOTE_GAMEMODE.asPhrase(new Component[0]), 1);
            itemIndex = 0;
            if (voteList.gamemodes().contains("regular")) {
                gamemodeOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.LIME_CONCRETE), BingoGamemode.REGULAR.asComponent().decorate(TextDecoration.BOLD), BingoMessage.INFO_REGULAR_DESC.asMultiline(new Component[0])), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteGamemode("regular", player);
                    gamemodeOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.gamemodes().contains("lockout")) {
                gamemodeOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.PINK_CONCRETE), BingoGamemode.LOCKOUT.asComponent().decorate(TextDecoration.BOLD), BingoMessage.INFO_LOCKOUT_DESC.asMultiline(new Component[0])), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteGamemode("lockout", player);
                    gamemodeOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.gamemodes().contains("complete")) {
                gamemodeOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.LIGHT_BLUE_CONCRETE), BingoGamemode.COMPLETE.asComponent().decorate(TextDecoration.BOLD), BingoMessage.INFO_COMPLETE_DESC.asMultiline(new Component[0])), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteGamemode("complete", player);
                    gamemodeOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.gamemodes().contains("hotswap")) {
                gamemodeOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.YELLOW_CONCRETE), BingoGamemode.HOTSWAP.asComponent().decorate(TextDecoration.BOLD), CollectionHelper.concatWithArrayCopy(BingoMessage.INFO_HOTSWAP_DESC_EXPIRE.asMultiline(new Component[0]), BingoMessage.INFO_HOTSWAP_DESC_ANY.asMultiline(Component.text("x")))), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteGamemode("hotswap", player);
                    gamemodeOptions.close(player);
                });
                ++itemIndex;
            }
            gamemodeOptions.addCloseAction(EXIT.copy());
            this.addAction(new ItemTemplate(positions[categoryIndex], 1, ItemTypePaper.of(Material.ENCHANTED_BOOK), BingoReloaded.applyTitleFormat(BingoMessage.VOTE_GAMEMODE.asPhrase(new Component[0])), new Component[0]), args -> gamemodeOptions.open(args.player()));
            ++categoryIndex;
        }
        if (!voteList.kits().isEmpty()) {
            BasicMenu kitOptions = new BasicMenu(menuBoard, BingoMessage.VOTE_KIT.asPhrase(new Component[0]), 1);
            itemIndex = 0;
            if (voteList.kits().contains("hardcore")) {
                kitOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.RED_DYE), PlayerKit.HARDCORE.getDisplayName(), BingoMessage.KIT_HARDCORE_DESC.asMultiline(new Component[0])).setGlowing(true), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteKit(PlayerKit.HARDCORE.configName, player);
                    kitOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.kits().contains("normal")) {
                kitOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.YELLOW_DYE), PlayerKit.NORMAL.getDisplayName(), BingoMessage.KIT_NORMAL_DESC.asMultiline(new Component[0])).setGlowing(true), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteKit(PlayerKit.NORMAL.configName, player);
                    kitOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.kits().contains("overpowered")) {
                kitOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.PURPLE_DYE), PlayerKit.OVERPOWERED.getDisplayName(), BingoMessage.KIT_OVERPOWERED_DESC.asMultiline(new Component[0])).setGlowing(true), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteKit(PlayerKit.OVERPOWERED.configName, player);
                    kitOptions.close(player);
                });
                ++itemIndex;
            }
            if (voteList.kits().contains("reloaded")) {
                kitOptions.addAction(new ItemTemplate(itemIndex, ItemTypePaper.of(Material.CYAN_DYE), PlayerKit.RELOADED.getDisplayName(), BingoMessage.KIT_RELOADED_DESC.asMultiline(new Component[0])).setGlowing(true), args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteKit(PlayerKit.RELOADED.configName, player);
                    kitOptions.close(player);
                });
                ++itemIndex;
            }
            BiConsumer<PlayerKit, Integer> addCustomKit = (kit, slot) -> kitOptions.addAction(new ItemTemplate((int)slot, ItemTypePaper.of(Material.GRAY_DYE), kit.getDisplayName(), new Component[0]).setGlowing(true), args -> {
                PlayerHandle player = args.player();
                this.lobby.voteKit(kit.configName, player);
                kitOptions.close(player);
            });
            if (voteList.kits().contains("custom_1") && PlayerKit.CUSTOM_1.isValid()) {
                addCustomKit.accept(PlayerKit.CUSTOM_1, itemIndex);
                ++itemIndex;
            }
            if (voteList.kits().contains("custom_2") && PlayerKit.CUSTOM_2.isValid()) {
                addCustomKit.accept(PlayerKit.CUSTOM_2, itemIndex);
                ++itemIndex;
            }
            if (voteList.kits().contains("custom_3") && PlayerKit.CUSTOM_3.isValid()) {
                addCustomKit.accept(PlayerKit.CUSTOM_3, itemIndex);
                ++itemIndex;
            }
            if (voteList.kits().contains("custom_4") && PlayerKit.CUSTOM_4.isValid()) {
                addCustomKit.accept(PlayerKit.CUSTOM_4, itemIndex);
                ++itemIndex;
            }
            if (voteList.kits().contains("custom_5") && PlayerKit.CUSTOM_5.isValid()) {
                addCustomKit.accept(PlayerKit.CUSTOM_5, itemIndex);
                ++itemIndex;
            }
            if (itemIndex < 8) {
                kitOptions.addCloseAction(EXIT.copy());
            }
            this.addAction(new ItemTemplate(positions[categoryIndex], 1, ItemTypePaper.of(Material.ENCHANTED_BOOK), BingoReloaded.applyTitleFormat(BingoMessage.VOTE_KIT.asPhrase(new Component[0])), new Component[0]), arguments -> kitOptions.open(arguments.player()));
            ++categoryIndex;
        }
        if (!voteList.cards().isEmpty()) {
            BasicMenu cardOptions = new BasicMenu(menuBoard, BingoMessage.VOTE_CARD.asPhrase(new Component[0]), 1);
            itemIndex = 0;
            for (String card : voteList.cards()) {
                Material material = Material.PAPER;
                ItemTemplate itemTemplate = new ItemTemplate(itemIndex, ItemTypePaper.of(material), Component.text(card).decorate(TextDecoration.BOLD), new Component[0]);
                cardOptions.addAction(itemTemplate, args -> {
                    PlayerHandle player = args.player();
                    this.lobby.voteCard(card, player);
                    cardOptions.close(player);
                });
                ++itemIndex;
            }
            if (itemIndex < 8) {
                cardOptions.addCloseAction(EXIT.copy());
            }
            this.addAction(new ItemTemplate(positions[categoryIndex], 1, ItemTypePaper.of(Material.ENCHANTED_BOOK), BingoReloaded.applyTitleFormat(BingoMessage.VOTE_CARD.asPhrase(new Component[0])), new Component[0]), args -> cardOptions.open(args.player()));
            ++categoryIndex;
        }
        if (!voteList.cardSizes().isEmpty()) {
            ItemTemplate smallSize;
            BasicMenu cardSizeOptions = new BasicMenu(menuBoard, BingoMessage.VOTE_CARDSIZE.asPhrase(new Component[0]), 1);
            itemIndex = 0;
            if (voteList.cardSizes().contains("3")) {
                smallSize = new ItemTemplate(itemIndex, ItemTypePaper.of(Material.RABBIT_HIDE), CardSize.X3.asComponent(), new Component[0]);
                cardSizeOptions.addAction(smallSize, args -> {
                    this.lobby.voteCardsize("3", args.player());
                    cardSizeOptions.close(args.player());
                });
            }
            ++itemIndex;
            if (voteList.cardSizes().contains("5")) {
                smallSize = new ItemTemplate(itemIndex, ItemTypePaper.of(Material.LEATHER), CardSize.X5.asComponent(), new Component[0]);
                cardSizeOptions.addAction(smallSize, args -> {
                    this.lobby.voteCardsize("5", args.player());
                    cardSizeOptions.close(args.player());
                });
            }
            if (++itemIndex < 8) {
                cardSizeOptions.addCloseAction(EXIT.copy());
            }
            this.addAction(new ItemTemplate(positions[categoryIndex], 1, ItemTypePaper.of(Material.ENCHANTED_BOOK), BingoReloaded.applyTitleFormat(BingoMessage.VOTE_CARDSIZE.asPhrase(new Component[0])), new Component[0]), args -> cardSizeOptions.open(args.player()));
            ++categoryIndex;
        }
        this.addCloseAction(EXIT.copyToSlot(0, 2));
    }
}

