/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.card;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gui.inventory.item.OpenCardSelectAction;
import io.github.steaf23.bingoreloaded.gui.inventory.item.TaskItemAction;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.MultilineComponent;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericCardMenu
extends BasicMenu
implements CardMenu {
    protected List<GameTask> tasks;
    private final CardDisplayInfo displayInfo;
    private final BingoReloaded bingo;

    public GenericCardMenu(BingoReloaded bingo, MenuBoard menuBoard, CardDisplayInfo displayInfo, @Nullable Component alternateTitle) {
        super(menuBoard, alternateTitle == null ? BingoMessage.CARD_TITLE.asPhrase(new Component[0]) : alternateTitle, displayInfo.size().size);
        this.bingo = bingo;
        this.tasks = new ArrayList<GameTask>();
        this.setMaxStackSizeOverride(64);
        this.displayInfo = displayInfo;
        if (displayInfo.allowViewingOtherCards()) {
            this.addAction(OpenCardSelectAction.createItem(bingo, 8));
        }
    }

    @Override
    public void updateTasks(List<GameTask> tasks) {
        this.tasks = tasks;
        for (int i = 0; i < tasks.size(); ++i) {
            this.addItem(this.getItemFromTask(i).setSlot(this.displayInfo().size().getCardInventorySlot(i)), new TaskItemAction(tasks.get(i)));
        }
    }

    @Override
    public CardMenu copy(@Nullable Component newTitle) {
        return new GenericCardMenu(this.bingo, this.getMenuBoard(), this.displayInfo(), newTitle);
    }

    @Override
    public CardDisplayInfo displayInfo() {
        return this.displayInfo;
    }

    @NotNull
    public ItemTemplate getItemFromTask(int taskIndex) {
        return this.tasks.get(taskIndex).toItem(this.displayInfo);
    }

    @Override
    public void setInfo(Component name, Component ... description) {
        ItemTemplate info = new ItemTemplate(0, ItemTypePaper.of(Material.MAP), name.decorate(TextDecoration.BOLD).color(this.displayInfo.mode().getColor()), MultilineComponent.from((TextColor)NamedTextColor.YELLOW, TextDecoration.ITALIC, description));
        this.addItem(info);
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        this.updateTasks(this.tasks);
    }

    public BingoReloaded bingo() {
        return this.bingo;
    }
}

