/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.card;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.api.HotswapCardMenu;
import io.github.steaf23.bingoreloaded.cards.hotswap.HotswapTaskHolder;
import io.github.steaf23.bingoreloaded.gui.inventory.card.GenericCardMenu;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotswapGenericCardMenu
extends GenericCardMenu
implements HotswapCardMenu {
    private List<HotswapTaskHolder> taskHolders;

    public HotswapGenericCardMenu(BingoReloaded bingo, MenuBoard menuBoard, CardDisplayInfo displayInfo, @Nullable Component alternateTitle) {
        super(bingo, menuBoard, displayInfo, alternateTitle);
    }

    @Override
    public void updateTasks(List<GameTask> tasks) {
        super.updateTasks(this.taskHolders.stream().map(HotswapTaskHolder::getTask).toList());
    }

    @Override
    public void updateTaskHolders(List<HotswapTaskHolder> holders) {
        this.taskHolders = holders;
        this.updateTasks(null);
    }

    @Override
    public CardMenu copy(@Nullable Component alternateTitle) {
        return new HotswapGenericCardMenu(this.bingo(), this.getMenuBoard(), this.displayInfo(), alternateTitle);
    }

    @Override
    @NotNull
    public ItemTemplate getItemFromTask(int taskIndex) {
        HotswapTaskHolder holder = this.taskHolders.get(taskIndex);
        return holder.convertToItem(this.displayInfo());
    }
}

