/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.card;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.api.HotswapCardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.cards.hotswap.HotswapTaskHolder;
import io.github.steaf23.bingoreloaded.data.TexturedMenuData;
import io.github.steaf23.bingoreloaded.gui.inventory.card.SlotBackgroundRenderer;
import io.github.steaf23.bingoreloaded.gui.inventory.card.TexturedCardMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.core.TexturedTitleBuilder;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotswapTexturedCardMenu
extends TexturedCardMenu
implements HotswapCardMenu {
    private List<HotswapTaskHolder> taskHolders;

    public HotswapTexturedCardMenu(BingoReloaded bingo, MenuBoard board, CardDisplayInfo displayInfo) {
        super(bingo, board, displayInfo);
    }

    @Override
    public void updateTasks(List<GameTask> tasks) {
        super.updateTasks(this.taskHolders.stream().map(HotswapTaskHolder::getTask).toList());
    }

    @Override
    protected Component buildTitle(BingoGamemode mode, CardSize size) {
        TexturedMenuData.Texture cardTexture = null;
        if (cardTexture == null) {
            return Component.empty();
        }
        TexturedTitleBuilder title = new TexturedTitleBuilder().addSpace(cardTexture.menuOffset()).addTexture(cardTexture).resetSpace();
        return title.build();
    }

    @Override
    public CardMenu copy(@Nullable Component alternateTitle) {
        return new HotswapTexturedCardMenu(this.bingo, this.getMenuBoard(), this.displayInfo());
    }

    @Override
    public void updateTaskHolders(List<HotswapTaskHolder> taskHolders) {
        this.taskHolders = taskHolders;
        this.updateTasks(null);
        HashMap<Integer, TextColor> completedSlots = new HashMap<Integer, TextColor>();
        for (int i = 0; i < this.tasks.size(); ++i) {
            int rawSlot = this.getSlotForTask(i);
            if (!((GameTask)this.tasks.get(i)).isCompleted()) continue;
            ((GameTask)this.tasks.get(i)).getCompletedByTeam().ifPresent(team -> completedSlots.put(rawSlot, team.getColor()));
        }
        Inventory oldInventory = this.getInventory();
        this.setOpenedInventory(Bukkit.createInventory(null, (int)54, (Component)this.getStartingTitle().append(SlotBackgroundRenderer.slotCompletedBackground(completedSlots))));
        this.setTaskItems();
        this.addItem(this.getInfo());
        if (oldInventory == null) {
            return;
        }
        ArrayList<HumanEntity> viewers = new ArrayList<HumanEntity>(oldInventory.getViewers());
        viewers.forEach(p -> p.openInventory(this.getInventory()));
    }

    @Override
    @NotNull
    public ItemTemplate getItemFromTask(int taskIndex) {
        ItemTemplate item = this.taskHolders.get(taskIndex).convertToItem(this.displayInfo());
        if (((GameTask)this.tasks.get(taskIndex)).isCompleted()) {
            item.setItemType(ItemTypePaper.of(Material.POISONOUS_POTATO));
            item.setCustomModelData("1012");
            item.setGlowing(false);
        }
        return item;
    }
}

