/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.card;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.api.CardMenu;
import io.github.steaf23.bingoreloaded.cards.CardSize;
import io.github.steaf23.bingoreloaded.data.TexturedMenuData;
import io.github.steaf23.bingoreloaded.gui.inventory.card.SlotBackgroundRenderer;
import io.github.steaf23.bingoreloaded.gui.inventory.core.TexturedTitleBuilder;
import io.github.steaf23.bingoreloaded.gui.inventory.item.OpenCardSelectAction;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuItemGroup;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.MultilineComponent;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TexturedCardMenu
implements InventoryMenu,
CardMenu {
    private final MenuBoard board;
    protected List<GameTask> tasks;
    protected BingoReloaded bingo;
    private final MenuItemGroup itemGroup;
    private final Component startingTitle;
    private Inventory openedInventory;
    private final CardDisplayInfo displayInfo;
    private ItemTemplate info;
    boolean openOnce = false;
    public static final ItemTemplate DUMMY_ITEM = new ItemTemplate(ItemTypePaper.of(Material.POISONOUS_POTATO));

    public TexturedCardMenu(BingoReloaded bingo, MenuBoard board, CardDisplayInfo displayInfo) {
        ItemTemplate info = DUMMY_ITEM.copyToSlot(0);
        this.bingo = bingo;
        this.board = board;
        this.tasks = new ArrayList<GameTask>();
        this.itemGroup = new MenuItemGroup();
        this.startingTitle = this.buildTitle(displayInfo.mode(), displayInfo.size());
        this.info = info;
        this.displayInfo = displayInfo;
        if (displayInfo.allowViewingOtherCards()) {
            this.addAction(OpenCardSelectAction.createItem(bingo, 8));
        }
    }

    protected Component buildTitle(BingoGamemode mode, CardSize size) {
        TexturedMenuData.Texture bannerTexture;
        TexturedMenuData textures = BingoReloaded.getTextureData();
        TexturedMenuData.Texture cardTexture = null;
        if (size == CardSize.X3) {
            cardTexture = textures.getTexture("card_3");
        } else if (size == CardSize.X5) {
            cardTexture = textures.getTexture("card_5");
        }
        switch (mode) {
            default: {
                throw new MatchException(null, null);
            }
            case REGULAR: {
                TexturedMenuData.Texture texture = textures.getTexture("banner_regular");
                break;
            }
            case LOCKOUT: {
                TexturedMenuData.Texture texture = textures.getTexture("banner_lockout");
                break;
            }
            case COMPLETE: {
                TexturedMenuData.Texture texture = textures.getTexture("banner_complete");
                break;
            }
            case HOTSWAP: {
                TexturedMenuData.Texture texture = bannerTexture = textures.getTexture("banner_hotswap");
            }
        }
        if (bannerTexture == null || cardTexture == null) {
            return Component.empty();
        }
        TexturedTitleBuilder title = new TexturedTitleBuilder().addSpace(cardTexture.menuOffset()).addTexture(cardTexture).resetSpace().addSpace(cardTexture.menuOffset()).addTexture(bannerTexture).resetSpace();
        return title.build();
    }

    @Override
    public void updateTasks(List<GameTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public void open(PlayerHandle entity) {
        this.board.open(this, entity);
    }

    @Override
    public MenuBoard getMenuBoard() {
        return this.board;
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        HashMap<Integer, TextColor> completedSlots = new HashMap<Integer, TextColor>();
        for (int i = 0; i < this.tasks.size(); ++i) {
            int rawSlot = this.getSlotForTask(i);
            if (!this.tasks.get(i).isCompleted()) continue;
            this.tasks.get(i).getCompletedByTeam().ifPresent(team -> completedSlots.put(rawSlot, team.getColor()));
        }
        Inventory oldInventory = this.openedInventory;
        this.openedInventory = Bukkit.createInventory(null, (int)54, (Component)this.startingTitle.append(SlotBackgroundRenderer.slotCompletedBackground(completedSlots)));
        this.setTaskItems();
        this.addItem(this.info);
        if (oldInventory == null) {
            return;
        }
        ArrayList<HumanEntity> viewers = new ArrayList<HumanEntity>(oldInventory.getViewers());
        viewers.forEach(p -> p.openInventory(this.openedInventory));
    }

    @Override
    public boolean onClick(InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        return this.itemGroup.handleClick(this, event, player, clickedSlot, clickType);
    }

    @Override
    public boolean onDrag(InventoryDragEvent event) {
        return true;
    }

    @Override
    public void onCustomAction(Key key, DataStorage payload) {
    }

    @Override
    public void beforeClosing(PlayerHandle player) {
    }

    @Override
    public boolean openOnce() {
        return this.openOnce;
    }

    @Override
    public void setOpenOnce(boolean value) {
        this.openOnce = value;
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.openedInventory;
    }

    protected void setOpenedInventory(@NotNull Inventory inventory) {
        this.openedInventory = inventory;
    }

    protected Component getStartingTitle() {
        return this.startingTitle;
    }

    @Override
    public CardMenu copy(@Nullable Component alternateTitle) {
        return new TexturedCardMenu(this.bingo, this.getMenuBoard(), this.displayInfo);
    }

    @Override
    public CardDisplayInfo displayInfo() {
        return this.displayInfo;
    }

    @NotNull
    protected ItemTemplate getItemFromTask(int taskIndex) {
        ItemTemplate item = this.tasks.get(taskIndex).toItem(this.displayInfo);
        if (this.tasks.get(taskIndex).isCompleted()) {
            item.setItemType(ItemTypePaper.of(Material.POISONOUS_POTATO));
            item.setCustomModelData("1012");
            item.setGlowing(false);
        }
        return item;
    }

    @Override
    public void setInfo(Component name, Component ... description) {
        this.info = DUMMY_ITEM.copyToSlot(0).setName(name.decorate(TextDecoration.BOLD).color(this.displayInfo.mode().getColor())).setLore(MultilineComponent.from((TextColor)NamedTextColor.YELLOW, TextDecoration.ITALIC, description)).setCustomModelData("1011");
    }

    public void addAction(@NotNull MenuAction action) {
        ItemTemplate item = action.item();
        this.itemGroup.addItem(item, action);
        this.getInventory().setItem(item.getSlot(), ((StackHandlePaper)item.buildItem()).handle());
    }

    public void addItem(@NotNull ItemTemplate item) {
        this.itemGroup.addItem(item, null);
        this.getInventory().setItem(item.getSlot(), ((StackHandlePaper)item.buildItem()).handle());
    }

    protected void setTaskItems() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            ItemTemplate item = this.getItemFromTask(i).setSlot(this.getSlotForTask(i));
            this.addItem(item);
        }
    }

    protected ItemTemplate getInfo() {
        return this.info;
    }

    public int getSlotForTask(int index) {
        int slot = this.displayInfo.size().getCardInventorySlot(index);
        if (this.displayInfo.size() == CardSize.X3) {
            slot += 9;
        }
        return slot;
    }
}

