/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.core;

import io.github.steaf23.bingoreloaded.data.TexturedMenuData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;

public class TexturedTitleBuilder {
    private final TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().color(NamedTextColor.WHITE);
    private int spaceCounter;

    public TexturedTitleBuilder addSpace(int amount) {
        this.spaceCounter += amount;
        this.componentBuilder.append((Component)Component.translatable("space." + amount));
        return this;
    }

    public TexturedTitleBuilder addTexture(TexturedMenuData.Texture texture, @Nullable TextColor modulate) {
        this.spaceCounter += texture.textureEnd() + 2;
        this.componentBuilder.append(Component.text(texture.character()).color(modulate));
        return this;
    }

    public TexturedTitleBuilder addTexture(TexturedMenuData.Texture texture) {
        return this.addTexture(texture, null);
    }

    public TexturedTitleBuilder resetSpace() {
        this.addSpace(-this.spaceCounter);
        return this;
    }

    public Component build() {
        return this.componentBuilder.build();
    }

    public Component resetAndBuild() {
        this.resetSpace();
        return this.build();
    }
}

