/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.TaskListData;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.CardEditorMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.ListEditorMenu;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.UserInputMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.util.BingoPlayerSender;
import java.util.ArrayList;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public class BingoCreatorMenu
extends BasicMenu {
    private final BingoCardData cardsData = new BingoCardData();
    public static final ItemTemplate CARD = new ItemTemplate(11, ItemTypePaper.of(Material.FILLED_MAP), BingoReloaded.applyTitleFormat("Edit Cards"), Component.text("Click to view and edit bingo cards!"));
    public static final ItemTemplate LIST = new ItemTemplate(15, ItemTypePaper.of(Material.PAPER), BingoReloaded.applyTitleFormat("Edit Lists"), Component.text("Click to view and edit bingo lists!"));
    private static final ItemType REMOVE_ICON = ItemTypePaper.of(Material.BARRIER);
    private static final ItemType COPY_ICON = ItemTypePaper.of(Material.SHULKER_SHELL);
    private static final ItemType RENAME_ICON = ItemTypePaper.of(Material.NAME_TAG);
    private static final ItemType SAVE_ICON = ItemTypePaper.of(Material.DIAMOND);

    public BingoCreatorMenu(MenuBoard manager) {
        super(manager, (Component)Component.text("Card Creator"), 3);
        this.addAction(CARD, arguments -> this.createCardPicker().open(arguments.player()));
        this.addAction(LIST, arguments -> this.createListPicker().open(arguments.player()));
    }

    private BasicMenu createCardPicker() {
        return new PaginatedSelectionMenu(this.getMenuBoard(), Component.text("Choose A Card"), new ArrayList(), FilterType.DISPLAY_NAME){
            private static final ItemTemplate CREATE_CARD = new ItemTemplate(51, ItemTypePaper.of(Material.EMERALD), ((TextComponent)Component.text("New Card").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), new Component[0]);

            @Override
            public void beforeOpening(PlayerHandle player) {
                this.addAction(CREATE_CARD, args -> BingoCreatorMenu.this.createCard(args.player()));
                this.clearItems();
                ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
                for (String card : BingoCreatorMenu.this.cardsData.getCardNames()) {
                    ItemTemplate item = new ItemTemplate(ItemTypePaper.of(Material.FILLED_MAP), Component.text(card), Component.text("This card contains " + BingoCreatorMenu.this.cardsData.getListNames(card).size() + " list(s)")).addDescription("input", 5, InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("more options")));
                    items.add(item);
                }
                this.addItemsToSelect(items);
            }

            @Override
            public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
                if (event.getClick() == ClickType.LEFT) {
                    BingoCreatorMenu.this.openCardEditor(clickedOption.getPlainTextName(), player);
                } else if (event.getClick() == ClickType.RIGHT) {
                    BingoCreatorMenu.this.createCardContext(clickedOption.getPlainTextName()).open(player);
                }
            }
        };
    }

    private BasicMenu createListPicker() {
        return new PaginatedSelectionMenu(this.getMenuBoard(), Component.text("Choose A List"), new ArrayList(), FilterType.DISPLAY_NAME){
            private static final ItemTemplate CREATE_LIST = new ItemTemplate(51, ItemTypePaper.of(Material.EMERALD), ((TextComponent)Component.text("New List").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), new Component[0]);

            @Override
            public void beforeOpening(PlayerHandle player) {
                TaskListData listsData = new TaskListData();
                this.addAction(CREATE_LIST, p -> BingoCreatorMenu.this.createList(player));
                this.clearItems();
                ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
                for (String list : listsData.getListNames()) {
                    ItemTemplate item = new ItemTemplate(ItemTypePaper.of(Material.PAPER), Component.text(list), Component.text("This list contains " + listsData.getTaskCount(list) + " task(s)")).addDescription("input", 5, InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("more options")));
                    items.add(item);
                }
                this.addItemsToSelect(items);
            }

            @Override
            public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
                if (event.getClick() == ClickType.LEFT) {
                    BingoCreatorMenu.this.openListEditor(clickedOption.getPlainTextName(), player);
                } else if (event.getClick() == ClickType.RIGHT) {
                    BingoCreatorMenu.this.createListContext(clickedOption.getPlainTextName()).open(player);
                }
            }
        };
    }

    public void createCard(PlayerHandle player) {
        new UserInputMenu(this.getMenuBoard(), Component.text("Enter new card name"), input -> {
            if (!input.isEmpty()) {
                this.openCardEditor(input.toLowerCase().replace(" ", "_"), player);
            }
        }, "name").open(player);
    }

    public void createList(PlayerHandle player) {
        new UserInputMenu(this.getMenuBoard(), Component.text("Enter new list name"), input -> {
            if (!input.isEmpty()) {
                this.openListEditor(input.toLowerCase().replace(" ", "_"), player);
            }
        }, "name").open(player);
    }

    private void openCardEditor(String cardName, PlayerHandle player) {
        if (BingoCardData.DEFAULT_CARD_NAMES.contains(cardName)) {
            BingoPlayerSender.sendMessage(Component.text("Cannot edit default card, use right click to duplicate them instead!").color(NamedTextColor.RED), (Audience)player);
            return;
        }
        CardEditorMenu editor = new CardEditorMenu(this.getMenuBoard(), cardName, this.cardsData);
        editor.open(player);
    }

    private void openListEditor(String listName, PlayerHandle player) {
        if (TaskListData.DEFAULT_LIST_NAMES.contains(listName)) {
            BingoPlayerSender.sendMessage(Component.text("Cannot edit default lists, use right click to duplicate them instead!").color(NamedTextColor.RED), (Audience)player);
            return;
        }
        ListEditorMenu editor = new ListEditorMenu(this.getMenuBoard(), listName);
        editor.open(player);
    }

    public BasicMenu createCardContext(String cardName) {
        BasicMenu context = new BasicMenu(this.getMenuBoard(), (Component)Component.text(cardName), 1);
        context.addAction(new ItemTemplate(0, REMOVE_ICON, BingoReloaded.applyTitleFormat("Remove"), new Component[0]), args -> {
            this.cardsData.removeCard(cardName);
            context.close(args.player());
        });
        context.addAction(new ItemTemplate(1, COPY_ICON, BingoReloaded.applyTitleFormat("Duplicate"), new Component[0]), args -> {
            this.cardsData.duplicateCard(cardName);
            context.close(args.player());
        });
        context.addAction(new ItemTemplate(2, RENAME_ICON, BingoReloaded.applyTitleFormat("Change Name"), new Component[0]), args -> new UserInputMenu(this.getMenuBoard(), Component.text("Change name to"), input -> {
            this.cardsData.renameCard(cardName, (String)input);
            context.close(args.player());
        }, cardName).open(args.player()));
        context.addCloseAction(new ItemTemplate(8, SAVE_ICON, BingoReloaded.applyTitleFormat(BingoMessage.MENU_EXIT.asPhrase(new Component[0])), new Component[0]));
        return context;
    }

    public BasicMenu createListContext(String listName) {
        TaskListData listsData = this.cardsData.lists();
        BasicMenu context = new BasicMenu(this.getMenuBoard(), (Component)Component.text(listName), 1);
        context.addAction(new ItemTemplate(0, REMOVE_ICON, BingoReloaded.applyTitleFormat("Remove"), new Component[0]), args -> {
            listsData.removeList(listName);
            context.close(args.player());
        });
        context.addAction(new ItemTemplate(1, COPY_ICON, BingoReloaded.applyTitleFormat("Duplicate"), new Component[0]), args -> {
            listsData.duplicateList(listName);
            context.close(args.player());
        });
        context.addAction(new ItemTemplate(2, RENAME_ICON, BingoReloaded.applyTitleFormat("Change Name"), new Component[0]), args -> new UserInputMenu(this.getMenuBoard(), Component.text("Change name to"), input -> {
            listsData.renameList(listName, (String)input);
            context.close(args.player());
        }, listName).open(args.player()));
        context.addCloseAction(new ItemTemplate(8, SAVE_ICON, BingoReloaded.applyTitleFormat(BingoMessage.MENU_EXIT.asPhrase(new Component[0])), new Component[0]));
        return context;
    }
}

