/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.ListValueEditorMenu;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public class CardEditorMenu
extends PaginatedSelectionMenu {
    public final String cardName;
    public final BingoCardData cardsData;
    private static final ItemTemplate ADD_LIST = new ItemTemplate(51, ItemTypePaper.of(Material.EMERALD), ((TextComponent)Component.text("Add Item List").color(NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), new Component[0]);

    public CardEditorMenu(MenuBoard menuBoard, String cardName, BingoCardData cardsData) {
        super(menuBoard, (Component)Component.text("Editing '" + cardName + "'"), new ArrayList<ItemTemplate>(), FilterType.DISPLAY_NAME);
        this.cardName = cardName;
        this.cardsData = cardsData;
        this.addAction(ADD_LIST, arguments -> this.createListPicker(result -> cardsData.setList(cardName, (String)result, cardsData.lists().getTaskCount((String)result), 1)).open(arguments.player()));
    }

    @Override
    public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
        String listName = clickedOption.getPlainTextName();
        if (listName.isEmpty()) {
            return;
        }
        if (event.getClick() == ClickType.LEFT) {
            new ListValueEditorMenu(this.getMenuBoard(), this, listName, this.cardsData.getListMax(this.cardName, listName), this.cardsData.getListMin(this.cardName, listName)).open(player);
        } else if (event.getClick() == ClickType.RIGHT) {
            this.cardsData.removeList(this.cardName, listName);
            this.updateCardDisplay();
        }
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        super.beforeOpening(player);
        this.updateCardDisplay();
    }

    public void updateCardDisplay() {
        this.clearItems();
        ArrayList<ItemTemplate> newItems = new ArrayList<ItemTemplate>();
        for (String listName : this.cardsData.getListNames(this.cardName)) {
            byte min = this.cardsData.getListMin(this.cardName, listName);
            byte max = this.cardsData.getListMax(this.cardName, listName);
            ItemTemplate item = new ItemTemplate(ItemTypePaper.of(Material.MAP), Component.text(listName), Component.text("This list contains " + this.cardsData.lists().getTaskCount(listName) + " task(s)"));
            item.addDescription("uses", 1, new Component[]{ComponentUtils.MINI_BUILDER.deserialize("At <bold>least</bold> <aqua>" + min + "</aqua> tasks will be used from this list."), ComponentUtils.MINI_BUILDER.deserialize("At <bold>most</bold> <aqua>" + max + "</aqua> tasks will be used from this list.")});
            item.addDescription("input", 5, InventoryMenu.INPUT_LEFT_CLICK.append(Component.text("edit distribution")), InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("remove this list")));
            item.setAmount(max);
            newItems.add(item);
        }
        this.addItemsToSelect(newItems);
        this.applyFilter(this.getAppliedFilter());
    }

    private BasicMenu createListPicker(final Consumer<String> result) {
        ArrayList<ItemTemplate> items = new ArrayList<ItemTemplate>();
        for (String listName : this.cardsData.lists().getListNames()) {
            items.add(new ItemTemplate(ItemTypePaper.of(Material.PAPER), Component.text(listName), Component.text("This list contains " + this.cardsData.lists().getTaskCount(listName) + " task(s)"), Component.text("Click to select").color(NamedTextColor.GRAY)).setCompareKey(listName));
        }
        return new PaginatedSelectionMenu(this, this.getMenuBoard(), Component.text("Pick A List"), items, FilterType.DISPLAY_NAME){

            @Override
            public void onOptionClickedDelegate(InventoryClickEvent event, ItemTemplate clickedOption, PlayerHandle player) {
                result.accept(clickedOption.getCompareKey());
                this.close(player);
            }
        };
    }
}

