/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.StatisticSelectionMenu;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.TaskPickerMenu;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.AdvancementTask;
import java.util.ArrayList;
import java.util.Iterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.advancement.Advancement;

public class ListEditorMenu
extends BasicMenu {
    private final String listName;
    private static final ItemTemplate ITEMS = new ItemTemplate(2, 2, ItemTypePaper.of(Material.APPLE), BingoReloaded.applyTitleFormat("Items"), Component.text("Click to add or remove items"));
    private static final ItemTemplate ADVANCEMENTS = new ItemTemplate(4, 2, ItemTypePaper.of(Material.ENDER_EYE), BingoReloaded.applyTitleFormat("Advancements"), Component.text("Click to add or remove advancements"));
    private static final ItemTemplate STATISTICS = new ItemTemplate(6, 2, ItemTypePaper.of(Material.GLOBE_BANNER_PATTERN), BingoReloaded.applyTitleFormat("Statistics"), Component.text("Click to add or remove statistics"));
    private static final ItemTemplate SAVE = new ItemTemplate(4, 5, ItemTypePaper.of(Material.REDSTONE), BingoMessage.MENU_SAVE_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);

    public ListEditorMenu(MenuBoard manager, String listName) {
        super(manager, (Component)Component.text("Editing '" + listName + "'"), 6);
        this.listName = listName;
        this.addAction(ITEMS, arguments -> this.createItemPicker(manager).open(arguments.player()));
        this.addAction(ADVANCEMENTS, arguments -> this.createAdvancementPicker(manager).open(arguments.player()));
        this.addAction(STATISTICS, arguments -> this.createStatisticsPicker(manager).open(arguments.player()));
        this.addCloseAction(SAVE);
        this.addItems(BLANK.copyToSlot(0, 5), BLANK.copyToSlot(1, 5), BLANK.copyToSlot(2, 5), BLANK.copyToSlot(3, 5), BLANK.copyToSlot(5, 5), BLANK.copyToSlot(6, 5), BLANK.copyToSlot(7, 5), BLANK.copyToSlot(8, 5));
    }

    public BasicMenu createStatisticsPicker(MenuBoard menuBoard) {
        return new StatisticSelectionMenu(menuBoard, this.listName);
    }

    private BasicMenu createItemPicker(MenuBoard menuBoard) {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        for (Material m : Material.values()) {
            if (m.name().contains("LEGACY_") || !m.isItem() || m.isAir()) continue;
            tasks.add(GameTask.simpleItemTask(ItemTypePaper.of(m), 1));
        }
        return new TaskPickerMenu(menuBoard, "Select Items", tasks, this.listName);
    }

    private BasicMenu createAdvancementPicker(MenuBoard menuBoard) {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        Iterator it = Bukkit.advancementIterator();
        while (it.hasNext()) {
            Advancement a = (Advancement)it.next();
            String key = a.getKey().getKey();
            if (key.startsWith("recipes/") || key.endsWith("/root")) continue;
            AdvancementTask task = new AdvancementTask(new AdvancementHandlePaper(a));
            tasks.add(new GameTask(task));
        }
        return new TaskPickerMenu(menuBoard, "Add Advancements", tasks, this.listName);
    }
}

