/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.CardEditorMenu;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.SpinBoxButtonAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;

public class ListValueEditorMenu
extends BasicMenu {
    private static final ItemTemplate CANCEL = new ItemTemplate(39, ItemTypePaper.of(Material.REDSTONE), BingoMessage.MENU_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);
    private static final ItemTemplate SAVE = new ItemTemplate(41, ItemTypePaper.of(Material.DIAMOND), BingoMessage.MENU_SAVE_EXIT.asPhrase(new Component[0]).color(NamedTextColor.AQUA).decorate(TextDecoration.BOLD), new Component[0]);
    private static final ItemTemplate INFO = new ItemTemplate(0, ItemTypePaper.of(Material.PAPER), BingoReloaded.applyTitleFormat("Edit list values"), Component.text("Here you can change how often"), Component.text("an item from this list "), Component.text("can appear on a card."));
    private final CardEditorMenu cardEditor;
    public int minCount;
    public int maxCount;
    private final String listName;

    public ListValueEditorMenu(MenuBoard menuBoard, CardEditorMenu parent, String listName, int maxStart, int minStart) {
        super(menuBoard, (Component)Component.text("Updating Values"), 6);
        this.cardEditor = parent;
        this.listName = listName;
        this.minCount = minStart;
        this.maxCount = maxStart;
        ItemTemplate minCounter = new ItemTemplate(2, 2, ItemTypePaper.of(Material.TARGET), BingoReloaded.applyTitleFormat(String.valueOf(this.minCount)), new Component[0]).setLore(Component.text("Not less than " + this.minCount + " item(s)"), Component.text("will be picked from this list"));
        ItemTemplate maxCounter = new ItemTemplate(6, 2, ItemTypePaper.of(Material.TARGET), BingoReloaded.applyTitleFormat(String.valueOf(this.maxCount)), new Component[0]).setLore(Component.text("Not more than " + this.maxCount + " item(s)"), Component.text("will be picked from this list"));
        SpinBoxButtonAction minCounterButtonAction = new SpinBoxButtonAction(1, this.maxCount, minStart);
        minCounterButtonAction.setItem(minCounter);
        this.addAction(minCounterButtonAction);
        SpinBoxButtonAction maxCounterButtonAction = new SpinBoxButtonAction(this.minCount, Math.min(36, this.cardEditor.cardsData.lists().getTaskCount(listName)), maxStart, value -> {
            maxCounter.setName(BingoReloaded.applyTitleFormat(String.valueOf(value)));
            maxCounter.setLore(Component.text("Not more than " + value + " item(s)"), Component.text("will be picked from this list"));
            this.maxCount = value;
            minCounterButtonAction.setMax(this.maxCount);
        });
        minCounterButtonAction.setCallback(value -> {
            minCounter.setName(BingoReloaded.applyTitleFormat(String.valueOf(value)));
            minCounter.setLore(Component.text("Not less than " + value + " item(s)"), Component.text("will be picked from this list"));
            this.minCount = value;
            maxCounterButtonAction.setMin(this.minCount);
        });
        maxCounterButtonAction.setItem(maxCounter);
        this.addAction(maxCounterButtonAction);
        this.addAction(SAVE, arguments -> {
            this.setValueForList();
            this.close(arguments.player());
        });
        this.addItem(INFO);
        this.addCloseAction(CANCEL);
    }

    private void setValueForList() {
        this.cardEditor.cardsData.setList(this.cardEditor.cardName, this.listName, this.maxCount, this.minCount);
        this.cardEditor.updateCardDisplay();
    }
}

