/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.gui.inventory.creator.TaskPickerMenu;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.StatisticTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.StatisticTask;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.Statistic;

public class StatisticSelectionMenu
extends BasicMenu {
    public String listName;
    protected static final ItemTemplate QUIT = new ItemTemplate(49, ItemTypePaper.of(Material.REDSTONE), BingoMessage.MENU_SAVE_EXIT.asPhrase(new Component[0]).color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);
    private static final Set<StatisticTypePaper> TRAVEL_STATS = StatisticSelectionMenu.getStatisticsInCategory(StatisticType.StatisticCategory.TRAVEL);
    private static final Set<StatisticTypePaper> DAMAGE_STATS = StatisticSelectionMenu.getStatisticsInCategory(StatisticType.StatisticCategory.DAMAGE);
    private static final Set<StatisticTypePaper> BLOCK_INTERACT_STATS = StatisticSelectionMenu.getStatisticsInCategory(StatisticType.StatisticCategory.BLOCK_INTERACT);
    private static final Set<StatisticTypePaper> CONTAINER_INTERACT_STATS = StatisticSelectionMenu.getStatisticsInCategory(StatisticType.StatisticCategory.CONTAINER_INTERACT);
    private static final Set<StatisticTypePaper> OTHER_STATS = StatisticSelectionMenu.getStatisticsInCategory(StatisticType.StatisticCategory.OTHER);

    public StatisticSelectionMenu(MenuBoard menuBoard, String listName) {
        super(menuBoard, (Component)Component.text("Pick Statistics"), 6);
        this.listName = listName;
        this.addAction(new ItemTemplate(1, 0, ItemTypePaper.of(Material.LEATHER_BOOTS), BingoReloaded.applyTitleFormat("Travel"), new Component[0]), args -> this.createTravelMenu().open(args.player()));
        this.addAction(new ItemTemplate(3, 0, ItemTypePaper.of(Material.DIAMOND_SWORD), BingoReloaded.applyTitleFormat("Kill"), new Component[0]), args -> this.createEntityMenu(Statistic.KILL_ENTITY).open(args.player()));
        this.addAction(new ItemTemplate(5, 0, ItemTypePaper.of(Material.SKELETON_SKULL), BingoReloaded.applyTitleFormat("Get Killed"), new Component[0]), args -> this.createEntityMenu(Statistic.ENTITY_KILLED_BY).open(args.player()));
        this.addAction(new ItemTemplate(7, 0, ItemTypePaper.of(Material.STONECUTTER), BingoReloaded.applyTitleFormat("Block Interactions"), new Component[0]), args -> this.createBlockInteractMenu().open(args.player()));
        this.addAction(new ItemTemplate(1, 2, ItemTypePaper.of(Material.CHEST), BingoReloaded.applyTitleFormat("Container Interactions"), new Component[0]), args -> this.createContainerMenu().open(args.player()));
        this.addAction(new ItemTemplate(3, 2, ItemTypePaper.of(Material.DIAMOND_PICKAXE), BingoReloaded.applyTitleFormat("Mine Block"), new Component[0]), args -> this.createBlockMenu(Statistic.MINE_BLOCK).open(args.player()));
        this.addAction(new ItemTemplate(5, 2, ItemTypePaper.of(Material.HOPPER), BingoReloaded.applyTitleFormat("Drop Item"), new Component[0]), args -> this.createItemMenu(Statistic.DROP).open(args.player()));
        this.addAction(new ItemTemplate(7, 2, ItemTypePaper.of(Material.SHEARS), BingoReloaded.applyTitleFormat("Use/Place Item"), new Component[0]), args -> this.createItemMenu(Statistic.USE_ITEM).open(args.player()));
        this.addAction(new ItemTemplate(1, 4, ItemTypePaper.of(Material.DEAD_BUSH), BingoReloaded.applyTitleFormat("Break Item"), new Component[0]), args -> this.createItemMenu(Statistic.BREAK_ITEM).open(args.player()));
        this.addAction(new ItemTemplate(3, 4, ItemTypePaper.of(Material.CRAFTING_TABLE), BingoReloaded.applyTitleFormat("Craft Item"), new Component[0]), args -> this.createItemMenu(Statistic.CRAFT_ITEM).open(args.player()));
        this.addAction(new ItemTemplate(5, 4, ItemTypePaper.of(Material.REDSTONE), BingoReloaded.applyTitleFormat("Damage Related"), new Component[0]), args -> this.createDamageMenu().open(args.player()));
        this.addAction(new ItemTemplate(7, 4, ItemTypePaper.of(Material.BAKED_POTATO), BingoReloaded.applyTitleFormat("Other"), new Component[0]), args -> this.createMiscMenu().open(args.player()));
        this.addCloseAction(QUIT);
        this.addItems(BLANK.copyToSlot(45), BLANK.copyToSlot(46), BLANK.copyToSlot(47), BLANK.copyToSlot(48), BLANK.copyToSlot(50), BLANK.copyToSlot(51), BLANK.copyToSlot(52), BLANK.copyToSlot(53));
    }

    private TaskPickerMenu createEntityMenu(Statistic stat) {
        Set<EntityType> entities = StatisticHandle.getValidEntityTypes();
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        entities.forEach(e -> tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper(new StatisticTypePaper(stat), (EntityType)e)))));
        return new TaskPickerMenu(this.getMenuBoard(), "Select Entities", tasks, this.listName);
    }

    private TaskPickerMenu createBlockMenu(Statistic stat) {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        for (Material m : Material.values()) {
            if (m.name().contains("LEGACY_") || !m.isBlock() || !m.isItem() || m.isAir()) continue;
            tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper(stat, m))));
        }
        return new TaskPickerMenu(this.getMenuBoard(), "Select Blocks", tasks, this.listName);
    }

    private TaskPickerMenu createItemMenu(Statistic stat) {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        for (Material m : Material.values()) {
            if (m.name().contains("LEGACY_") || !m.isItem() || m.isAir()) continue;
            tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper(stat, m))));
        }
        return new TaskPickerMenu(this.getMenuBoard(), "Select Items", tasks, this.listName);
    }

    public TaskPickerMenu createTravelMenu() {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        TRAVEL_STATS.forEach(type -> tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper((StatisticTypePaper)type)))));
        return new TaskPickerMenu(this.getMenuBoard(), "Travel Statistics", tasks, this.listName);
    }

    private TaskPickerMenu createContainerMenu() {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        CONTAINER_INTERACT_STATS.forEach(type -> tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper((StatisticTypePaper)type)))));
        return new TaskPickerMenu(this.getMenuBoard(), "Container Statistics", tasks, this.listName);
    }

    private TaskPickerMenu createBlockInteractMenu() {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        BLOCK_INTERACT_STATS.forEach(type -> tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper((StatisticTypePaper)type)))));
        return new TaskPickerMenu(this.getMenuBoard(), "Select Blocks", tasks, this.listName);
    }

    private TaskPickerMenu createDamageMenu() {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        DAMAGE_STATS.forEach(type -> tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper((StatisticTypePaper)type)))));
        return new TaskPickerMenu(this.getMenuBoard(), "Damage Statistics", tasks, this.listName);
    }

    private TaskPickerMenu createMiscMenu() {
        ArrayList<GameTask> tasks = new ArrayList<GameTask>();
        OTHER_STATS.forEach(type -> {
            switch (type.handle()) {
                case TIME_SINCE_DEATH: 
                case TIME_SINCE_REST: 
                case TOTAL_WORLD_TIME: 
                case LEAVE_GAME: {
                    break;
                }
                default: {
                    tasks.add(new GameTask(new StatisticTask(new StatisticHandlePaper((StatisticTypePaper)type))));
                }
            }
        });
        return new TaskPickerMenu(this.getMenuBoard(), "Other Statistics", tasks, this.listName);
    }

    private static Set<StatisticTypePaper> getStatisticsInCategory(StatisticType.StatisticCategory category) {
        return StatisticTypePaper.STATISTIC_CATEGORY_MAP.keySet().stream().filter(s -> StatisticTypePaper.STATISTIC_CATEGORY_MAP.get(s).equals((Object)category)).map(StatisticTypePaper::new).collect(Collectors.toSet());
    }
}

