/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.gui.inventory.creator;

import io.github.steaf23.bingoreloaded.api.CardDisplayInfo;
import io.github.steaf23.bingoreloaded.data.BingoCardData;
import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.MenuFilterSettings;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedDataMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.tasks.GameTask;
import io.github.steaf23.bingoreloaded.tasks.data.TaskData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.inventory.InventoryClickEvent;

public class TaskPickerMenu
extends PaginatedDataMenu<GameTask> {
    private final String listName;
    protected static final Component[] SELECTED_LORE = TaskPickerMenu.createSelectedLore();
    protected static final Component[] UNSELECTED_LORE = TaskPickerMenu.createUnselectedLore();

    public TaskPickerMenu(MenuBoard board, String initialTitle, List<GameTask> options, String listName) {
        super(board, (Component)Component.text(initialTitle), options, FilterType.CUSTOM);
        this.listName = listName;
    }

    @Override
    public void onOptionClickedDelegate(InventoryClickEvent event, GameTask clickedOption, PlayerHandle player) {
        switch (event.getClick()) {
            case LEFT: {
                this.incrementItemCount(clickedOption, 1);
                break;
            }
            case SHIFT_LEFT: {
                this.incrementItemCount(clickedOption, 10);
                break;
            }
            case RIGHT: {
                this.decrementItemCount(clickedOption, 1);
                break;
            }
            case SHIFT_RIGHT: {
                this.decrementItemCount(clickedOption, 10);
            }
        }
    }

    @Override
    public ItemTemplate toItem(GameTask gameTask, boolean isSelected) {
        ItemTemplate item = gameTask.toItem(CardDisplayInfo.DUMMY_DISPLAY_INFO);
        Component[] addedLore = isSelected ? SELECTED_LORE : UNSELECTED_LORE;
        item.setLore(gameTask.data.getItemDescription());
        item.addDescription("selected", 5, addedLore);
        return item;
    }

    @Override
    public boolean filterData(GameTask gameTask, MenuFilterSettings filter) {
        return PlainTextComponentSerializer.plainText().serialize(gameTask.data.getName()).toLowerCase().contains(filter.name().toLowerCase());
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
        super.beforeOpening(player);
        BingoCardData cardsData = new BingoCardData();
        Set<TaskData> tasks = cardsData.lists().getTasks(this.listName, true, true);
        for (GameTask item : this.getAllItems()) {
            TaskData itemData = item.data;
            TaskData savedTask = null;
            for (TaskData t : tasks) {
                if (!t.isTaskEqual(itemData)) continue;
                savedTask = t;
                break;
            }
            if (savedTask == null) continue;
            item.data = savedTask;
            this.selectItem(item, true);
        }
    }

    @Override
    public void beforeClosing(PlayerHandle player) {
        super.beforeClosing(player);
        BingoCardData cardsData = new BingoCardData();
        cardsData.lists().saveTasksFromGroup(this.listName, this.getAllItems().stream().map(item -> item.data).collect(Collectors.toList()), this.getSelectedItems().stream().map(item -> item.data).collect(Collectors.toList()));
    }

    public void incrementItemCount(GameTask item, int by) {
        int count;
        boolean alreadySelected = this.getSelectedItems().contains(item);
        int newAmount = count = item.data.getRequiredAmount();
        if (alreadySelected && (newAmount = Math.min(64, newAmount + by)) == count) {
            return;
        }
        item.data = item.data.setRequiredAmount(newAmount);
        this.selectItem(item, true);
    }

    public void decrementItemCount(GameTask item, int by) {
        boolean deselect = false;
        if (!this.getSelectedItems().contains(item)) {
            return;
        }
        int count = item.data.getRequiredAmount();
        if (count == 1) {
            deselect = true;
        }
        int newAmount = count;
        if (!deselect) {
            newAmount = Math.max(1, newAmount - by);
        }
        item.data = item.data.setRequiredAmount(newAmount);
        this.selectItem(item, !deselect);
    }

    private static Component[] createSelectedLore() {
        return new Component[]{ComponentUtils.MINI_BUILDER.deserialize("<white><italic> - <dark_purple>This task has been added to the list")};
    }

    private static Component[] createUnselectedLore() {
        return new Component[]{ComponentUtils.MINI_BUILDER.deserialize("<white><italic> - <gray>Click to make this task"), Component.text("   appear on bingo cards", (TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC)};
    }
}

