/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.action;

import io.github.steaf23.bingoreloaded.lib.action.ActionResult;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ActionTree {
    protected final List<ActionTree> subActions = new ArrayList<ActionTree>();
    protected final String name;
    private Function<String[], ActionResult> action;
    private final List<String> permissionWhitelist;
    protected String usage;
    protected Function<String[], List<String>> tabCompletionForArgs;
    protected ActionUser lastUser = null;

    public ActionTree(String name, List<String> permissionWhitelist, Function<String[], ActionResult> action) {
        this.name = name;
        this.action = action;
        this.usage = "";
        this.permissionWhitelist = permissionWhitelist;
        this.tabCompletionForArgs = args -> List.of();
    }

    public ActionTree(String name, Function<String[], ActionResult> action) {
        this(name, List.of(), action);
    }

    public ActionTree(String name, List<String> permissionWhitelist) {
        this(name, permissionWhitelist, null);
    }

    public ActionTree setAction(Function<String[], ActionResult> action) {
        this.action = action;
        return this;
    }

    public ActionTree addSubAction(ActionTree subAction) {
        this.subActions.add(subAction);
        return this;
    }

    public ActionTree addUsage(String usage) {
        this.usage = usage;
        return this;
    }

    public ActionTree addTabCompletion(Function<String[], List<String>> tabCompletionForArgs) {
        this.tabCompletionForArgs = tabCompletionForArgs;
        return this;
    }

    public ActionResult execute(ActionUser user, String ... arguments) {
        this.lastUser = user;
        if (!this.hasPermission(user)) {
            return ActionResult.NO_PERMISSION;
        }
        if (this.action != null) {
            if (this.subActions.isEmpty()) {
                return this.action.apply(arguments);
            }
            if (arguments.length == 0) {
                return this.action.apply(arguments);
            }
        }
        if (arguments.length == 0) {
            return ActionResult.INCORRECT_USE;
        }
        ActionTree cmd = this.getSubCommand(arguments[0]);
        if (cmd != null) {
            return cmd.execute(this.lastUser, Arrays.copyOfRange(arguments, 1, arguments.length));
        }
        return ActionResult.INCORRECT_USE;
    }

    public boolean hasPermission(ActionUser user) {
        return this.permissionWhitelist.isEmpty() || user.hasAnyPermission(this.permissionWhitelist);
    }

    @Nullable
    public List<String> tabComplete(ActionUser user, String ... arguments) {
        if (this.subActions.isEmpty()) {
            return this.tabCompletionForArgs.apply(arguments);
        }
        if (arguments.length == 1) {
            return this.subActions.stream().filter(cmd -> cmd.hasPermission(user)).map(cmd -> cmd.name).collect(Collectors.toList());
        }
        ActionTree cmd2 = this.getSubCommand(arguments[0]);
        if (cmd2 != null) {
            return cmd2.tabComplete(user, Arrays.copyOfRange(arguments, 1, arguments.length));
        }
        return List.of();
    }

    public ActionTree getSubCommand(String name) {
        for (ActionTree actionTree : this.subActions) {
            if (!actionTree.name.equals(name)) continue;
            return actionTree;
        }
        return null;
    }

    public String usage(String ... arguments) {
        return "/" + this.determineUsage(arguments);
    }

    protected String determineUsage(String ... arguments) {
        if (this.subActions.isEmpty() || arguments.length == 0) {
            return this.name + " " + this.usage;
        }
        ActionTree cmd = this.getSubCommand(arguments[0]);
        if (cmd != null) {
            return this.name + " " + cmd.determineUsage(Arrays.copyOfRange(arguments, 1, arguments.length));
        }
        if (arguments.length == 1) {
            return this.name + " <" + this.subActions.stream().map(subCommand -> subCommand.name).collect(Collectors.joining(" | ")) + ">";
        }
        return "";
    }

    public ActionUser getLastUser() {
        return this.lastUser;
    }

    public String name() {
        return this.name;
    }
}

