/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.action;

import io.github.steaf23.bingoreloaded.lib.action.ActionResult;
import io.github.steaf23.bingoreloaded.lib.action.ActionTree;
import io.github.steaf23.bingoreloaded.lib.api.ActionUser;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeferredAction
extends ActionTree {
    private final String deferredArgument;

    public DeferredAction(String name, String deferredArgumentName, List<String> requiredPermissions) {
        super(name, requiredPermissions);
        this.deferredArgument = deferredArgumentName;
    }

    @Override
    public List<String> tabComplete(ActionUser user, String ... arguments) {
        String deferred = "<" + this.deferredArgument + ">";
        if (arguments.length <= 1) {
            if (this.tabCompletionForArgs != null) {
                List completions = (List)this.tabCompletionForArgs.apply(arguments);
                if (!completions.isEmpty()) {
                    return (List)this.tabCompletionForArgs.apply(arguments);
                }
                return List.of(deferred);
            }
            return List.of(deferred);
        }
        if (arguments.length == 2) {
            return this.subActions.stream().map(cmd -> cmd.name).collect(Collectors.toList());
        }
        ActionTree cmd2 = this.getSubCommand(arguments[1]);
        String userArgument = arguments[0];
        if (cmd2 != null) {
            String[] finalArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            finalArguments[0] = userArgument;
            return cmd2.tabComplete(user, finalArguments);
        }
        return List.of();
    }

    @Override
    public ActionResult execute(ActionUser user, String ... arguments) {
        this.lastUser = user;
        if (this.subActions.isEmpty()) {
            ConsoleMessenger.bug("Wrongly formatted action by plugin {this is a developer mistake!}", (Object)this);
            return ActionResult.IGNORED;
        }
        if (arguments.length <= 1) {
            return ActionResult.INCORRECT_USE;
        }
        ActionTree cmd = this.getSubCommand(arguments[1]);
        String userArgument = arguments[0];
        if (cmd != null) {
            String[] finalArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            finalArguments[0] = userArgument;
            return cmd.execute(user, finalArguments);
        }
        return ActionResult.INCORRECT_USE;
    }

    @Override
    protected String determineUsage(String ... arguments) {
        if (this.subActions.isEmpty()) {
            return this.name + " " + this.usage;
        }
        if (arguments.length <= 2) {
            return this.name + " <" + this.deferredArgument + "> <" + this.subActions.stream().map(subCommand -> subCommand.name).collect(Collectors.joining(" | ")) + ">";
        }
        ActionTree cmd = this.getSubCommand(arguments[1]);
        String userArgument = arguments[0];
        if (cmd != null) {
            String[] finalArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            finalArguments[0] = userArgument;
            return this.name + " <" + this.deferredArgument + "> " + cmd.determineUsage(finalArguments);
        }
        return this.name;
    }
}

