/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api;

import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.DimensionType;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.EntityTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.ExtensionInfo;
import io.github.steaf23.bingoreloaded.lib.api.ExtensionTask;
import io.github.steaf23.bingoreloaded.lib.api.ExtensionTaskPaper;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.StatisticTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.StatusEffectType;
import io.github.steaf23.bingoreloaded.lib.api.StatusEffectTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.WorldOptions;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackBuilderPaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerInfo;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperServerSoftware
implements ServerSoftware {
    private final JavaPlugin plugin;

    public PaperServerSoftware(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public InputStream getResource(String filePath) {
        return this.plugin.getResource(filePath);
    }

    @Override
    public void saveResource(String name, boolean replace) {
        this.plugin.saveResource(name, replace);
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public Collection<? extends PlayerHandle> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(PlayerHandlePaper::new).toList();
    }

    @Override
    @Nullable
    public PlayerHandle getPlayerFromUniqueId(UUID id) {
        Player p = Bukkit.getPlayer((UUID)id);
        if (p == null) {
            return null;
        }
        return new PlayerHandlePaper(p);
    }

    @Override
    @Nullable
    public PlayerHandle getPlayerFromName(String name) {
        Player p = Bukkit.getPlayer((String)name);
        if (p == null) {
            return null;
        }
        return new PlayerHandlePaper(p);
    }

    @Override
    @NotNull
    public PlayerInfo getPlayerInfo(UUID playerId) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)playerId);
        return new PlayerInfo(playerId, offline.getName());
    }

    @Override
    @NotNull
    public PlayerInfo getPlayerInfo(String playerName) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)playerName);
        return new PlayerInfo(offline.getUniqueId(), playerName);
    }

    @Override
    public ItemType resolveItemType(Key key) {
        return new ItemTypePaper((Material)Registry.MATERIAL.get(key));
    }

    @Override
    @Nullable
    public DimensionType resolveDimensionType(Key key) {
        DimensionType type = null;
        if (key.value().equals("overworld")) {
            type = DimensionType.OVERWORLD == null ? () -> Key.key("minecraft:overworld") : DimensionType.OVERWORLD;
        } else if (key.value().equals("nether")) {
            type = DimensionType.NETHER == null ? () -> Key.key("minecraft:nether") : DimensionType.NETHER;
        } else if (key.value().equals("the_end")) {
            type = DimensionType.THE_END == null ? () -> Key.key("minecraft:the_end") : DimensionType.THE_END;
        }
        return type;
    }

    @Override
    public EntityType resolveEntityType(Key key) {
        org.bukkit.entity.EntityType type = (org.bukkit.entity.EntityType)Registry.ENTITY_TYPE.get(key);
        if (type == null) {
            return null;
        }
        return new EntityTypePaper(type);
    }

    @Override
    public AdvancementHandle resolveAdvancement(Key key) {
        return new AdvancementHandlePaper(Bukkit.getAdvancement((NamespacedKey)new NamespacedKey(key.namespace(), key.value())));
    }

    @Override
    public StatisticType resolveStatisticType(Key key) {
        Statistic stat = (Statistic)Registry.STATISTIC.get(key);
        if (stat == null) {
            return null;
        }
        return new StatisticTypePaper(stat);
    }

    @Override
    public StatusEffectType resolvePotionEffectType(Key key) {
        PotionEffectType type = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(key);
        if (type == null) {
            return null;
        }
        return new StatusEffectTypePaper(type);
    }

    @Override
    public ExtensionInfo getExtensionInfo() {
        return new ExtensionInfo(this.plugin.getPluginMeta().getName(), this.plugin.getPluginMeta().getVersion(), this.plugin.getPluginMeta().getAuthors());
    }

    @Override
    public ComponentLogger getComponentLogger() {
        return this.plugin.getComponentLogger();
    }

    @Override
    public Collection<WorldHandle> getLoadedWorlds() {
        return Bukkit.getWorlds().stream().map(this::fromWorld).toList();
    }

    @Override
    @Nullable
    public WorldHandle getWorld(String worldName) {
        return this.fromWorld(Bukkit.getWorld((String)worldName));
    }

    @Override
    @Nullable
    public WorldHandle getWorld(UUID worldId) {
        return this.fromWorld(Bukkit.getWorld((UUID)worldId));
    }

    @Override
    @Nullable
    public WorldHandle createWorld(WorldOptions options) {
        WorldCreator creator = new WorldCreator(options.name());
        if (options.dimension().equals(DimensionType.OVERWORLD)) {
            creator.environment(World.Environment.NORMAL);
        } else if (options.dimension().equals(DimensionType.NETHER)) {
            creator.environment(World.Environment.NETHER);
        } else if (options.dimension().equals(DimensionType.THE_END)) {
            creator.environment(World.Environment.THE_END);
        } else {
            ConsoleMessenger.bug("Unknown dimension " + options.dimension().key().asString() + " for creating bingo world", (Object)this);
        }
        return this.fromWorld(Bukkit.createWorld((WorldCreator)creator));
    }

    @Override
    public boolean unloadWorld(@NotNull WorldHandle world, boolean save) {
        return Bukkit.unloadWorld((World)((WorldHandlePaper)world).handle(), (boolean)save);
    }

    @Override
    public StackHandle createStack(ItemType type, int amount) {
        Material mat = ((ItemTypePaper)type).handle();
        return new StackHandlePaper(new ItemStack(mat, amount));
    }

    @Override
    public StackHandle createStackFromBytes(byte[] bytes) {
        return new StackHandlePaper(ItemStack.deserializeBytes((byte[])bytes));
    }

    @Override
    public StackHandle createStackFromTemplate(ItemTemplate template, boolean hideAttributes) {
        return new StackBuilderPaper().buildItem(template, hideAttributes);
    }

    @Override
    public byte[] createBytesFromStack(StackHandle stack) {
        return ((StackHandlePaper)stack).handle().serializeAsBytes();
    }

    @Override
    public StackHandle colorItemStack(StackHandle stack, TextColor color) {
        if (!ItemTemplate.LEATHER_ARMOR.contains(stack.type())) {
            return stack;
        }
        ((StackHandlePaper)stack).handle().setData(DataComponentTypes.DYED_COLOR, (Object)DyedItemColor.dyedItemColor((Color)Color.fromRGB((int)color.value())));
        return stack;
    }

    @Override
    public StatisticHandle createStatistic(StatisticType type, @Nullable ItemType item, @Nullable EntityType entity) {
        return new StatisticHandlePaper((StatisticTypePaper)type, entity, item);
    }

    @Override
    public boolean areAdvancementsDisabled() {
        return !Bukkit.advancementIterator().hasNext() || Bukkit.advancementIterator().next() == null;
    }

    @Override
    public ExtensionTask runTaskTimer(long repeatTicks, long startDelayTicks, Consumer<ExtensionTask> consumer) {
        ExtensionTaskPaper wrapper = new ExtensionTaskPaper();
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            wrapper.setTask((BukkitTask)task);
            consumer.accept(wrapper);
        }, startDelayTicks, repeatTicks);
        return wrapper;
    }

    @Override
    public ExtensionTask runTask(Consumer<ExtensionTask> consumer) {
        ExtensionTaskPaper wrapper = new ExtensionTaskPaper();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, task -> {
            wrapper.setTask((BukkitTask)task);
            consumer.accept(wrapper);
        });
        return wrapper;
    }

    @Override
    public ExtensionTask runTask(long startDelayTicks, Consumer<ExtensionTask> consumer) {
        if (startDelayTicks <= 0L) {
            return this.runTask(consumer);
        }
        ExtensionTaskPaper wrapper = new ExtensionTaskPaper();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task -> {
            wrapper.setTask((BukkitTask)task);
            consumer.accept(wrapper);
        }, startDelayTicks);
        return wrapper;
    }

    @Override
    public void sendConsoleCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Nullable
    private WorldHandle fromWorld(@Nullable World world) {
        return world == null ? null : new WorldHandlePaper(world);
    }

    public FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
    }
}

