/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public interface StatisticHandle {
    public static final Set<EntityType> VALID_ENTITIES_FOR_STATISTICS = StatisticHandle.cacheValidEntityTypes();

    default public boolean isEntityValid() {
        return VALID_ENTITIES_FOR_STATISTICS.contains(this.entityType());
    }

    public StatisticType statisticType();

    @Nullable
    public ItemType itemType();

    @Nullable
    public EntityType entityType();

    public boolean isSubStatistic();

    public String translationKey();

    default public boolean hasItemType() {
        return this.itemType() != null;
    }

    default public boolean hasEntity() {
        return this.entityType() != null;
    }

    public boolean getsUpdatedAutomatically();

    public ItemType icon();

    public static StatisticHandle create(StatisticType type, @Nullable ItemType item, @Nullable EntityType entity) {
        return PlatformResolver.get().createStatistic(type, item, entity);
    }

    public static Set<EntityType> getValidEntityTypes() {
        return VALID_ENTITIES_FOR_STATISTICS;
    }

    private static Set<EntityType> cacheValidEntityTypes() {
        return BingoReloaded.runtime().getValidEntityTypesForStatistics();
    }
}

