/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api;

import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.EntityTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.StatisticTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.util.StatisticsKeyConverter;
import java.util.Objects;
import net.kyori.adventure.key.Keyed;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record StatisticHandlePaper(@NotNull StatisticTypePaper statistic, @Nullable EntityType entityType, @Nullable ItemType itemType) implements StatisticHandle
{
    public StatisticHandlePaper(StatisticTypePaper stat) {
        this(stat, null, null);
    }

    public StatisticHandlePaper(StatisticTypePaper stat, @Nullable EntityType entityType) {
        this(stat, entityType, null);
    }

    public StatisticHandlePaper(StatisticTypePaper stat, @Nullable ItemType itemType) {
        this(stat, null, itemType);
    }

    public StatisticHandlePaper(Statistic stat) {
        this(new StatisticTypePaper(stat), null, null);
    }

    public StatisticHandlePaper(Statistic stat, @NotNull org.bukkit.entity.EntityType entityType) {
        this(new StatisticTypePaper(stat), new EntityTypePaper(entityType), null);
    }

    public StatisticHandlePaper(Statistic stat, @NotNull Material itemType) {
        this(new StatisticTypePaper(stat), null, ItemTypePaper.of(itemType));
    }

    public static StatisticHandlePaper create(Statistic stat, @Nullable org.bukkit.entity.EntityType entity, @Nullable Material itemType) {
        if (entity == null && itemType != null) {
            return new StatisticHandlePaper(new StatisticTypePaper(stat), null, ItemTypePaper.of(itemType));
        }
        if (entity != null && itemType == null) {
            return new StatisticHandlePaper(new StatisticTypePaper(stat), new EntityTypePaper(entity), null);
        }
        if (entity == null && itemType == null) {
            return new StatisticHandlePaper(new StatisticTypePaper(stat), null, null);
        }
        return new StatisticHandlePaper(new StatisticTypePaper(stat), new EntityTypePaper(entity), ItemTypePaper.of(itemType));
    }

    @Override
    public StatisticType statisticType() {
        return this.statistic;
    }

    @Override
    public boolean isSubStatistic() {
        return this.statistic.handle().isSubstatistic();
    }

    @Override
    public String translationKey() {
        return StatisticsKeyConverter.getMinecraftTranslationKey(this.statistic.handle());
    }

    @Override
    public boolean getsUpdatedAutomatically() {
        if (this.statistic.getCategory() == StatisticType.StatisticCategory.TRAVEL) {
            return false;
        }
        return switch (this.statistic.handle()) {
            case Statistic.PLAY_ONE_MINUTE, Statistic.SNEAK_TIME, Statistic.TOTAL_WORLD_TIME, Statistic.TIME_SINCE_REST, Statistic.TIME_SINCE_DEATH -> false;
            default -> true;
        };
    }

    public static String createDescription(Statistic stat) {
        switch (stat) {
            default: 
        }
        return "";
    }

    @Override
    @NotNull
    public ItemType icon() {
        return switch (this.statistic.handle()) {
            default -> throw new MatchException(null, null);
            case Statistic.DAMAGE_DEALT -> ItemTypePaper.of(Material.DIAMOND_SWORD);
            case Statistic.DAMAGE_TAKEN -> ItemTypePaper.of(Material.IRON_CHESTPLATE);
            case Statistic.DEATHS -> ItemTypePaper.of(Material.SKELETON_SKULL);
            case Statistic.MOB_KILLS -> ItemTypePaper.of(Material.CREEPER_HEAD);
            case Statistic.PLAYER_KILLS -> ItemTypePaper.of(Material.PLAYER_HEAD);
            case Statistic.FISH_CAUGHT -> ItemTypePaper.of(Material.TROPICAL_FISH);
            case Statistic.ANIMALS_BRED -> ItemTypePaper.of(Material.WHEAT);
            case Statistic.LEAVE_GAME -> ItemTypePaper.of(Material.BARRIER);
            case Statistic.JUMP -> ItemTypePaper.of(Material.RABBIT_FOOT);
            case Statistic.DROP_COUNT, Statistic.HOPPER_INSPECTED -> ItemTypePaper.of(Material.HOPPER);
            case Statistic.PLAY_ONE_MINUTE -> ItemTypePaper.of(Material.CLOCK);
            case Statistic.TOTAL_WORLD_TIME -> ItemTypePaper.of(Material.FILLED_MAP);
            case Statistic.WALK_ONE_CM -> ItemTypePaper.of(Material.LEATHER_BOOTS);
            case Statistic.WALK_ON_WATER_ONE_CM -> ItemTypePaper.of(Material.ICE);
            case Statistic.FALL_ONE_CM -> ItemTypePaper.of(Material.LAVA_BUCKET);
            case Statistic.SNEAK_TIME -> ItemTypePaper.of(Material.SCULK_SHRIEKER);
            case Statistic.CLIMB_ONE_CM -> ItemTypePaper.of(Material.EMERALD_ORE);
            case Statistic.FLY_ONE_CM -> ItemTypePaper.of(Material.COMMAND_BLOCK);
            case Statistic.WALK_UNDER_WATER_ONE_CM -> ItemTypePaper.of(Material.GOLDEN_BOOTS);
            case Statistic.MINECART_ONE_CM -> ItemTypePaper.of(Material.MINECART);
            case Statistic.BOAT_ONE_CM -> ItemTypePaper.of(Material.OAK_BOAT);
            case Statistic.PIG_ONE_CM -> ItemTypePaper.of(Material.CARROT_ON_A_STICK);
            case Statistic.HORSE_ONE_CM -> ItemTypePaper.of(Material.SADDLE);
            case Statistic.SPRINT_ONE_CM -> ItemTypePaper.of(Material.FEATHER);
            case Statistic.CROUCH_ONE_CM -> ItemTypePaper.of(Material.SCULK_SENSOR);
            case Statistic.AVIATE_ONE_CM -> ItemTypePaper.of(Material.ELYTRA);
            case Statistic.TIME_SINCE_DEATH -> ItemTypePaper.of(Material.RECOVERY_COMPASS);
            case Statistic.TALKED_TO_VILLAGER -> ItemTypePaper.of(Material.POPPY);
            case Statistic.TRADED_WITH_VILLAGER -> ItemTypePaper.of(Material.EMERALD);
            case Statistic.CAKE_SLICES_EATEN -> ItemTypePaper.of(Material.CAKE);
            case Statistic.CAULDRON_FILLED -> ItemTypePaper.of(Material.CAULDRON);
            case Statistic.CAULDRON_USED -> ItemTypePaper.of(Material.WATER_BUCKET);
            case Statistic.ARMOR_CLEANED -> ItemTypePaper.of(Material.LEATHER_CHESTPLATE);
            case Statistic.BANNER_CLEANED -> ItemTypePaper.of(Material.WHITE_BANNER);
            case Statistic.BREWINGSTAND_INTERACTION -> ItemTypePaper.of(Material.BREWING_STAND);
            case Statistic.BEACON_INTERACTION -> ItemTypePaper.of(Material.BEACON);
            case Statistic.DROPPER_INSPECTED -> ItemTypePaper.of(Material.DROPPER);
            case Statistic.DISPENSER_INSPECTED -> ItemTypePaper.of(Material.DISPENSER);
            case Statistic.NOTEBLOCK_PLAYED, Statistic.NOTEBLOCK_TUNED -> ItemTypePaper.of(Material.NOTE_BLOCK);
            case Statistic.FLOWER_POTTED -> ItemTypePaper.of(Material.FLOWER_POT);
            case Statistic.TRAPPED_CHEST_TRIGGERED -> ItemTypePaper.of(Material.TRAPPED_CHEST);
            case Statistic.ENDERCHEST_OPENED -> ItemTypePaper.of(Material.ENDER_CHEST);
            case Statistic.ITEM_ENCHANTED -> ItemTypePaper.of(Material.ENCHANTING_TABLE);
            case Statistic.RECORD_PLAYED -> ItemTypePaper.of(Material.MUSIC_DISC_CAT);
            case Statistic.FURNACE_INTERACTION -> ItemTypePaper.of(Material.FURNACE);
            case Statistic.CRAFTING_TABLE_INTERACTION -> ItemTypePaper.of(Material.CRAFTING_TABLE);
            case Statistic.CHEST_OPENED -> ItemTypePaper.of(Material.CHEST);
            case Statistic.SLEEP_IN_BED -> ItemTypePaper.of(Material.RED_BED);
            case Statistic.SHULKER_BOX_OPENED -> ItemTypePaper.of(Material.SHULKER_BOX);
            case Statistic.TIME_SINCE_REST -> ItemTypePaper.of(Material.YELLOW_BED);
            case Statistic.SWIM_ONE_CM -> ItemTypePaper.of(Material.BUBBLE_CORAL);
            case Statistic.DAMAGE_DEALT_ABSORBED -> ItemTypePaper.of(Material.DAMAGED_ANVIL);
            case Statistic.DAMAGE_DEALT_RESISTED -> ItemTypePaper.of(Material.NETHERITE_SWORD);
            case Statistic.DAMAGE_BLOCKED_BY_SHIELD -> ItemTypePaper.of(Material.SHIELD);
            case Statistic.DAMAGE_ABSORBED -> ItemTypePaper.of(Material.SPONGE);
            case Statistic.DAMAGE_RESISTED -> ItemTypePaper.of(Material.DIAMOND_CHESTPLATE);
            case Statistic.CLEAN_SHULKER_BOX -> ItemTypePaper.of(Material.SHULKER_SHELL);
            case Statistic.OPEN_BARREL -> ItemTypePaper.of(Material.BARREL);
            case Statistic.INTERACT_WITH_BLAST_FURNACE -> ItemTypePaper.of(Material.BLAST_FURNACE);
            case Statistic.INTERACT_WITH_SMOKER -> ItemTypePaper.of(Material.SMOKER);
            case Statistic.INTERACT_WITH_LECTERN -> ItemTypePaper.of(Material.LECTERN);
            case Statistic.INTERACT_WITH_CAMPFIRE -> ItemTypePaper.of(Material.CAMPFIRE);
            case Statistic.INTERACT_WITH_CARTOGRAPHY_TABLE -> ItemTypePaper.of(Material.CARTOGRAPHY_TABLE);
            case Statistic.INTERACT_WITH_LOOM -> ItemTypePaper.of(Material.LOOM);
            case Statistic.INTERACT_WITH_STONECUTTER -> ItemTypePaper.of(Material.STONECUTTER);
            case Statistic.BELL_RING -> ItemTypePaper.of(Material.BELL);
            case Statistic.RAID_TRIGGER -> ItemTypePaper.of(Material.CROSSBOW);
            case Statistic.RAID_WIN -> ItemTypePaper.of(Material.TOTEM_OF_UNDYING);
            case Statistic.INTERACT_WITH_ANVIL -> ItemTypePaper.of(Material.ANVIL);
            case Statistic.INTERACT_WITH_GRINDSTONE -> ItemTypePaper.of(Material.GRINDSTONE);
            case Statistic.TARGET_HIT -> ItemTypePaper.of(Material.TARGET);
            case Statistic.INTERACT_WITH_SMITHING_TABLE -> ItemTypePaper.of(Material.SMITHING_TABLE);
            case Statistic.STRIDER_ONE_CM -> ItemTypePaper.of(Material.WARPED_FUNGUS_ON_A_STICK);
            case Statistic.HAPPY_GHAST_ONE_CM -> ItemTypePaper.of(Material.DRIED_GHAST);
            case Statistic.DROP, Statistic.PICKUP, Statistic.MINE_BLOCK, Statistic.USE_ITEM, Statistic.BREAK_ITEM, Statistic.CRAFT_ITEM, Statistic.KILL_ENTITY, Statistic.ENTITY_KILLED_BY -> this.rootStatIcon(this.statistic.handle());
        };
    }

    private ItemType rootStatIcon(Statistic statistic) {
        if (statistic.getType() == Statistic.Type.ITEM || statistic.getType() == Statistic.Type.BLOCK) {
            return this.itemType();
        }
        if (this.entityType() != null && statistic.getType() == Statistic.Type.ENTITY) {
            return ItemType.of("minecraft:" + this.entityType().key().value() + "_spawn_egg");
        }
        return ItemTypePaper.of(Material.GLOBE_BANNER_PATTERN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        StatisticTypePaper stat;
        Keyed keyed;
        if (!(o instanceof StatisticHandlePaper)) return false;
        StatisticHandlePaper statisticHandlePaper = (StatisticHandlePaper)o;
        try {
            stat = keyed = statisticHandlePaper.statistic();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Keyed entity = keyed = statisticHandlePaper.entityType();
        Keyed item = keyed = statisticHandlePaper.itemType();
        if (!Objects.equals(this.itemType, item)) return false;
        if (!Objects.equals(this.entityType, entity)) return false;
        if (!Objects.equals(this.statistic, stat)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statistic, this.entityType, this.itemType);
    }
}

